% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_ntile.R
\name{mutate_ntile}
\alias{mutate_ntile}
\title{Add a column of ntiles to a data table}
\usage{
mutate_ntile(DT, col, n, by = NULL, keyby = NULL, new.col = NULL,
  overwrite = TRUE, check.na = FALSE)
}
\arguments{
\item{DT}{A \code{data.table}.}

\item{col}{The column name (quoted or unquoted) for which quantiles are desired.}

\item{n}{A positive integer, the number of groups to split \code{col}.}

\item{by, keyby}{Produce a grouped quantile column, as in \code{\link[data.table]{data.table}}.
\code{keyby} will set a key on the result (\emph{i.e.} order by \code{keyby}).}

\item{new.col}{If not \code{NULL}, the name of the column to be added. 
If \code{NULL} (the default) a name will be inferred from \code{n}. 
(For example, \code{n = 100} will be \code{<col>Percentile}).}

\item{overwrite}{(logical, default: \code{TRUE}) If \code{TRUE} and
\code{new.col} already exists in \code{DT}, the column will be overwritten.
If \code{FALSE}, attempting to overwrite an existing column is an error.}

\item{check.na}{(logical, default: \code{FALSE}) If \code{TRUE}, \code{NA}s
in \code{DT[[col]]} will throw an error. If \code{NA}'s are present, the 
corresponding n-tile may take any value.}
}
\value{
\code{DT} with a new integer column \code{new.col} containing the quantiles.
}
\description{
Add a column of ntiles to a data table
}
\examples{
library(data.table)
DT <- data.table(x = 1:20, y = 2:1)
mutate_ntile(DT, "x", n = 10)
mutate_ntile(DT, "x", n = 5)
mutate_ntile(DT, "x", n = 10, by = "y")
mutate_ntile(DT, "x", n = 10, keyby = "y")

}
