% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearquarter-scale.R
\name{scale_x_grates_yearquarter}
\alias{scale_x_grates_yearquarter}
\title{Yearquarter scale}
\usage{
scale_x_grates_yearquarter(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6L,
  format = NULL
)
}
\arguments{
\item{...}{Not currently used.}

\item{breaks}{A \verb{<grates_yearquarter>} vector of the desired breaks.}

\item{n.breaks}{\verb{[integer]}

Approximate number of breaks calculated using \code{scales::breaks_pretty}
(default 6L).

Will only have an effect if \code{breaks = waiver()}.}

\item{format}{Format to use if "Date" scales are required.

If not NULL then the value is used by \code{format.Date()} and can be any input
acceptable by that function.}
}
\value{
A scale for use with ggplot2.
}
\description{
ggplot2 scale for a yearquarter vector.
}
\examples{
\dontshow{if (requireNamespace("outbreaks") && requireNamespace("ggplot2")) withAutoprint(\{ # examplesIf}

# use simulated linelist data from the outbreaks package
linelist <- outbreaks::ebola_sim_clean$linelist

# calculate quarterly cases by date of infection
x <- as_yearquarter(linelist$date_of_infection)
(dat <- aggregate(list(cases = x), by = list(quarter = x), FUN = length))

# by default labels are centred
(quarter_plot <-
    ggplot2::ggplot(dat, ggplot2::aes(quarter, cases)) +
    ggplot2::geom_col(width = 1, colour = "white") +
    ggplot2::theme_bw() +
    ggplot2::theme(
        axis.text.x = ggplot2::element_text(
            angle = 45,
            hjust = 1
        )
    ) +
    ggplot2::xlab(""))

# To obtain centred labels you must explicitly set a date format
# in the scale:
quarter_plot + scale_x_grates_yearquarter(format = "\%Y-\%m-\%d")
\dontshow{\}) # examplesIf}
}
