% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_period.R
\name{as_int_period}
\alias{as_int_period}
\alias{as_int_period.default}
\alias{as_int_period.integer}
\alias{as_int_period.double}
\title{Coerce an object to an int_period (Experimental)}
\usage{
as_int_period(x, n, ...)

\method{as_int_period}{default}(x, n = 1L, ...)

\method{as_int_period}{integer}(x, n = 1L, ...)

\method{as_int_period}{double}(x, n = 1L, ...)
}
\arguments{
\item{x}{An \R object.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{n}{\verb{[integer]}

Number of consecutive integers that are being grouped.

Must be greater than 0.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A \verb{<grates_int_period>} object.
}
\description{
\code{as_int_period()} is a generic for coercing input in to \verb{<grates_int_period>}.
}
\note{
Internally \code{grates_int_period} objects are stored as the position, starting
at 0, of n-integer groups from 0. Here n-months is taken to mean a 'grouping
of n consecutive integers'.
}
\examples{
as_int_period(1:10, n = 4L)

}
\keyword{internal}
