% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiweek.R
\name{as_epiweek}
\alias{as_epiweek}
\alias{as_epiweek.default}
\alias{as_epiweek.Date}
\alias{as_epiweek.POSIXt}
\alias{as_epiweek.character}
\alias{as_epiweek.factor}
\title{Coerce to a epiweek object}
\usage{
as_epiweek(x, ...)

\method{as_epiweek}{default}(x, ...)

\method{as_epiweek}{Date}(x, ...)

\method{as_epiweek}{POSIXt}(x, ...)

\method{as_epiweek}{character}(x, format, tryFormats = c("\%Y-\%m-\%d", "\%Y/\%m/\%d"), ...)

\method{as_epiweek}{factor}(x, format, tryFormats = c("\%Y-\%m-\%d", "\%Y/\%m/\%d"), ...)
}
\arguments{
\item{x}{\R object.}

\item{...}{Other values passed to as.Date().}

\item{format}{\verb{[character]}

Passed to as.Date() unless \code{format = "yearweek"} in which case input is
assumed to be in the form "YYYY-Wxx".

If not specified, it will try tryFormats one by one on the first non-NA
element, and give an error if none works. Otherwise, the processing is via
\code{strptime()} whose help page describes available conversion specifications.}

\item{tryFormats}{\verb{[character]}

Format strings to try if format is not specified.}
}
\value{
A \verb{<grates_epiweek>} object.
}
\description{
Generic for conversion to \verb{<grates_epiweek>}
}
\details{
\itemize{
\item Date, POSIXct, and POSIXlt are converted with the timezone respected.
\item Character objects are first coerced to date via \code{as.Date()} unless
\code{format = "yearweek"} in which case input is assumed to be in the form
"YYYY-Wxx" and parsed accordingly.
}
}
\examples{
as_epiweek(Sys.Date())
as_epiweek(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))
as_epiweek("2019-05-03")
as_epiweek("2019-W12", format = "yearweek")

}
\seealso{
\code{new_epiweek()} and \code{as.Date()}.
}
