% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_examples.R
\name{generate_random_connected_graph}
\alias{generate_random_connected_graph}
\title{Generate a random connected graph}
\usage{
generate_random_connected_graph(
  d,
  m = NULL,
  p = 2/(d + 1),
  maxTries = 1000,
  ...
)
}
\arguments{
\item{d}{Number of vertices in the graph}

\item{m}{Number of edges in the graph (specify this or \code{p})}

\item{p}{Probability of each edge being in the graph (specify this or \code{m})}

\item{maxTries}{Maximum number of tries to produce a connected Eroes-Renyi graph}

\item{...}{Ignored, only allowed for compatibility}
}
\value{
An [\code{igraph::graph}] object
}
\description{
Generates a random connected graph.
First tries to generate an Erdoes-Renyi graph, if that fails, falls back
to producing a tree and adding random edges to that tree.
}
\seealso{
Other Example generations: 
\code{\link{generate_random_Gamma}()},
\code{\link{generate_random_cactus}()},
\code{\link{generate_random_chordal_graph}()},
\code{\link{generate_random_graphical_Gamma}()},
\code{\link{generate_random_integer_Gamma}()},
\code{\link{generate_random_model}()},
\code{\link{generate_random_spd_matrix}()},
\code{\link{generate_random_tree}()}
}
\concept{Example generations}
