% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_examples.R
\name{generate_random_chordal_graph}
\alias{generate_random_chordal_graph}
\title{Generate a random chordal graph}
\usage{
generate_random_chordal_graph(
  d,
  cMin = 2,
  cMax = 6,
  sMin = 1,
  sMax = 4,
  block_graph = FALSE,
  ...
)
}
\arguments{
\item{d}{Number of vertices in the graph}

\item{cMin}{Minimal size of cliques (last clique might be smaller if necessary)}

\item{cMax}{Maximal size of cliques}

\item{sMin}{Minimal size of separators}

\item{sMax}{Maximal size of separators}

\item{block_graph}{Force \verb{sMin == sMax == 1} to produce a block graph}

\item{...}{Ignored, only allowed for compatibility}
}
\value{
An [\code{igraph::graph}] object
}
\description{
Generates a random chordal graph by starting with a (small) complete graph
and then adding new cliques until the specified size is reached.
The sizes of cliques and separators can be specified.
}
\seealso{
Other Example generations: 
\code{\link{generate_random_Gamma}()},
\code{\link{generate_random_cactus}()},
\code{\link{generate_random_connected_graph}()},
\code{\link{generate_random_graphical_Gamma}()},
\code{\link{generate_random_integer_Gamma}()},
\code{\link{generate_random_model}()},
\code{\link{generate_random_spd_matrix}()},
\code{\link{generate_random_tree}()}
}
\concept{Example generations}
