% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_one_letter.R
\name{as_one_letter}
\alias{as_one_letter}
\title{Convert three-letter amino acid codes to one-letter codes}
\usage{
as_one_letter(x)
}
\arguments{
\item{x}{A character vector of three-letter amino acid codes, e.g. \code{"Ser"},
\code{"Arg"}, \code{"Leu"}, or \code{"Asx"}.}
}
\value{
A character vector of one-letter amino acid codes, e.g. \code{"S"}, \code{"R"},
\code{"L"}, or \code{"B"}.
}
\description{
Converts three-letter amino acid abbreviations to one-letter codes, e.g., Leu
to L. The accepted codes in the input include the 20
standard amino acids and also Asx (Asparagine or Aspartic acid), converted
to B, and Glx (Glutamine or Glutamic acid) converted to Z.
}
\examples{
# Convert Ser to S, Arg to R and Pro to P.
as_one_letter(c('Ser', 'Arg', 'Pro'))

# The function `as_one_letter()` is case insensitive on the input but will
# always return the one-letter codes in uppercase.
as_one_letter(c('ser', 'ArG', 'PRO'))

# Convert the codes of the 20 standard amino acids. Note that the function
# `amino_acids()` returns the three-letter codes of the 20 standard amino
# acids.
as_one_letter(amino_acids())

# Convert also special case codes Asx (Asparagine or Aspartic acid) and Glx
# (Glutamine or Glutamic acid)
as_one_letter(c('Asx', 'Glx'))

# Invalid codes in the input are converted to NA.
# "Ser" is correctly mapped to "S" but "Serine" is not as it is not a
# three-letter amino acid code (the same applies to "Glucose").
as_one_letter(c('Ser', 'Serine', 'Glucose'))

}
