% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotScatter}
\alias{PlotScatter}
\title{Make a scatter plot}
\usage{
PlotScatter(
  data,
  x = NULL,
  y = NULL,
  xcol = NULL,
  ycol = NULL,
  xlab = NULL,
  ylab = NULL,
  log = FALSE,
  log.x = log,
  log.y = log,
  remove.outlier = 1.5,
  xlim = NULL,
  ylim = NULL,
  size = 0.3,
  genes = NULL,
  highlight = NULL,
  label = NULL,
  label.repel = 1,
  facet = NULL,
  color = NULL,
  density.margin = "n",
  density.n = 100,
  correlation = NULL,
  correlation.x = -Inf,
  correlation.y = Inf,
  correlation.hjust = 0.5,
  correlation.vjust = 0.5,
  layers.below = NULL
)
}
\arguments{
\item{data}{the grandR object (can also be a plain data frame)}

\item{x}{an expression to compute the x value or a character corresponding to a sample (or cell) name or a fully qualified analysis result name (see details)}

\item{y}{an expression to compute the y value or a character corresponding to a sample (or cell) name or a fully qualified analysis result name (see details)}

\item{xcol}{a character corresponding to a sample (or cell) name or a fully qualified analysis result name (see details)}

\item{ycol}{a character corresponding to a sample (or cell) name or a fully qualified analysis result name (see details)}

\item{xlab}{the label for x (can be NULL, then the x parameter is used)}

\item{ylab}{the label for y (can be NULL, then the y parameter is used)}

\item{log}{if TRUE, use log scales for x and y axis}

\item{log.x}{if TRUE, use log scale for the x axis}

\item{log.y}{if TRUE, use log scale for the y axis}

\item{remove.outlier}{configure how outliers are selected (is the coef parameter to \link[grDevices]{boxplot.stats}); can be FALSE, in which case no points are considered outliers (see details)}

\item{xlim}{define the x axis limits (vector of length 2 defining the lower and upper bound, respectively)}

\item{ylim}{define the y axis limits (vector of length 2 defining the lower and upper bound, respectively)}

\item{size}{the point size to use}

\item{genes}{restrict to these genes; can be either numeric indices, gene names, gene symbols or a logical vector}

\item{highlight}{highlight these genes; can be either numeric indices, gene names, gene symbols or a logical vector (see details)}

\item{label}{label these genes; can be either numeric indices, gene names, gene symbols or a logical vector (see details)}

\item{label.repel}{force to repel labels from points and each other (increase if labels overlap)}

\item{facet}{an expression (evaluated in the same environment as x and y); for each unique value a panel (facet) is created; can be NULL}

\item{color}{either NULL (use point density colors), or a name of the \link{GeneInfo} table (use scale_color_xxx to define colors), or a color for all points}

\item{density.margin}{for density colors, one of 'n','x' or 'y'; should the density be computed along both axes ('n'), or along 'x' or 'y' axis only}

\item{density.n}{how many bins to use for density calculation (see \link[MASS]{kde2d})}

\item{correlation}{a function to format correlation statistics to be annotated (see details)}

\item{correlation.x}{x coordinate to put the correlation annotation in the plot (see details)}

\item{correlation.y}{y coordinate to put the correlation annotation in the plot (see details)}

\item{correlation.hjust}{x adjustment to put the correlation annotation in the plot (see details)}

\item{correlation.vjust}{y adjustment to put the correlation annotation in the plot (see details)}

\item{layers.below}{list of ggplot geoms to add before adding the layer containing the points}
}
\value{
a ggplot object with the data frame used as the df attribute
}
\description{
Convenience method to compare two variables (slot data or analyses results).
}
\details{
Both the x and y parameter are either expressions or names. Names are either sample (or cell, in case of single cell experiments) names or
fully qualified analysis results (analysis name followed by a dot and the analysis result table column). These names can be used within expressions.
Defining by names only works with character literals like "kinetics.Synthesis", but if you give an expression (e.g. a variable name that contains a character),
this won't work, since PlotScatter will try to evaluate this for defining the values, not the name of the column. If you wanna define names, and use
some expression for this, you need to use the xcol and ycol parameters instead of the x and y parameters!

By default the limits of x and y axis are chosen after removing outliers (using the same algorithm used for \link{boxplot}). Thus, larger numbers filter
less stringently. remove.outlier can also be set to FALSE (no outlier filtering). If xlim or ylim are set, this overrides outlier filtering. Points outside of the limits
(i.e. outliers or points outside of xlim or ylim) are set to infinity (such that they are shown at the border of the plot in gray)

By default, all genes are shown. This can be restricted using the \code{genes} parameter (see \link{ToIndex}). It is also possible to highlight a subset of the genes
using \code{highlight}. This parameter either describes a subset of the genes (either numeric indices, gene names, gene symbols or a logical vector), in which case these genes
are plotted in red and with larger points size, or it can be a list of such vectors. The names of this list must be valid colors. Genes can also be labeled (make sure that this
is really only a small subset of the genes).

Often scatter plots show that x and y coordinates are correlated. Correlations can be annotated using the \link{FormatCorrelation} function. Most often you will use
\code{PlotScatter(data,x,y,correlation=FormatCorrelation())}. To use a different correlation measure, other formats for correlation coefficient and P values or omit one of these
statistics, parametrize \code{FormatCorrelation}. Use correlation.x and correlation.y to place the annotation in the plot, and correlation.hjust/correlation.vjust to align the
annotation at the given x,y coordinates. Infinite values for correlation.x/correlation.y will put the annotation at the border of the plot.
}
\concept{globalplot}
