% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{LFC}
\alias{LFC}
\title{Estimation of log2 fold changes}
\usage{
LFC(
  data,
  name.prefix = mode,
  contrasts,
  slot = "count",
  LFC.fun = lfc::PsiLFC,
  mode = "total",
  normalization = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{the grandR object}

\item{name.prefix}{the prefix for the new analysis name; a dot and the column names of the contrast matrix are appended; can be NULL (then only the contrast matrix names are used)}

\item{contrasts}{contrast matrix that defines all pairwise comparisons, generated using \link{GetContrasts}}

\item{slot}{the slot of the grandR object to take the data from; for \link[lfc]{PsiLFC}, this really should be "count"!}

\item{LFC.fun}{function to compute log fold changes (default: \link[lfc]{PsiLFC}, other viable option: \link[lfc]{NormLFC})}

\item{mode}{compute LFCs for "total", "new", or "old" RNA}

\item{normalization}{normalize on "total", "new", or "old" (see details)}

\item{verbose}{print status messages?}

\item{...}{further arguments forwarded to LFC.fun}
}
\value{
a new grandR object including a new analysis table. The columns of the new analysis table are
\itemize{
 \item{"LFC"}{the log2 fold change}
}
}
\description{
Estimate the log fold changes based on a contrast matrix, requires the LFC package.
}
\details{
Both \link[lfc]{PsiLFC} and  \link[lfc]{NormLFC}) by default perform normalization by subtracting the median log2 fold change from all log2 fold changes.
When computing LFCs of new RNA, it might be sensible to normalize w.r.t. to total RNA, i.e. subtract the median log2 fold change of total RNA from all the log2 fold change of new RNA.
This can be accomplished by setting mode to "new", and normalization to "total"!
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c(Design$Condition,Design$dur.4sU,Design$Replicate))
sars <- subset(sars,Coldata(sars,Design$dur.4sU)==2)
sars<-LFC(sars,mode="total",contrasts=GetContrasts(sars,contrast=c("Condition","Mock")))
sars<-LFC(sars,mode="new",normalization="total",
                            contrasts=GetContrasts(sars,contrast=c("Condition","Mock")))
head(GetAnalysisTable(sars))

}
\seealso{
\link{PairwiseDESeq2},\link{GetContrasts}
}
\concept{diffexp}
