% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_histogram.R
\name{plot_histogram}
\alias{plot_histogram}
\title{Plot data distribution as histograms.}
\usage{
plot_histogram(
  data,
  ycol,
  group,
  facet,
  PlotType = c("Counts", "Normalised counts"),
  BinSize = 30,
  c_alpha = 0.8,
  TextXAngle = 0,
  facet_scales = "fixed",
  fontsize = 20,
  linethick,
  alpha,
  LogYTrans,
  LogYBreaks = waiver(),
  LogYLabels = waiver(),
  LogYLimits = NULL,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy", "kelly",
    "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  SingleColour = NULL,
  ...
)
}
\arguments{
\item{data}{a data table e.g. data.frame or tibble.}

\item{ycol}{name of the column (without quotes) with the quantitative variable whose histogram distribution is to be plotted.}

\item{group}{name of the column containing a categorical grouping variable.}

\item{facet}{add another variable (without quotes) from the data table to create faceted graphs using \code{\link[ggplot2]{facet_wrap}}.}

\item{PlotType}{the default (\code{Counts}) plot will plot counts in the bins, which can be changed to \verb{Normalised counts}.}

\item{BinSize}{number of distinct bins to use on X-axis, default set to 30.}

\item{c_alpha}{fractional opacity of colour filled within histograms, default set to 0.8 (i.e. 80\% opacity).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{facet_scales}{whether or not to fix scales on X & Y axes for all facet facet graphs. Can be \code{fixed} (default), \code{free}, \code{free_y} or \code{free_x} (for Y and X axis one at a time, respectively).}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{\link[ggplot2]{theme_classic}}, default set to size 20.}

\item{linethick}{thickness of symbol border, default set to \code{fontsize}/22.}

\item{alpha}{deprecated old argument for \code{c_alpha}; retained for backward compatibility.}

\item{LogYTrans}{transform Y axis into "log10" or "log2" (in quotes).}

\item{LogYBreaks}{argument for \code{\link[ggplot2]{scale_y_continuous}} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogYLabels}{argument for \code{\link[ggplot2]{scale_y_continuous}} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogYLimits}{a vector of length two specifying the range (minimum and maximum) of the Y axis.}

\item{ColPal}{grafify colour palette to apply (in quotes), default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{SingleColour}{a colour hexcode (starting with #, e.g., "#E69F00"), a number between 1-154, or names of colours from \code{grafify} palettes or base R to fill along X-axis aesthetic. Accepts any colour other than "black"; use \code{grey_lin11}, which is almost black.}

\item{...}{any additional arguments to pass to \code{\link[ggplot2]{geom_histogram}}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, a quantitative variable (\code{ycol}) and a grouping variable (\code{group}), if available, and plots a histogram graph using \code{\link[ggplot2]{geom_histogram}}).  Alternatives are \code{\link{plot_density}}, or \code{\link{plot_qqline}}.
}
\details{
Note that the function requires the quantitative Y variable first, and groups them based on a categorical variable passed on via the \code{group} argument. The grouping variable is mapped to the \code{fill} aesthetics in \code{\link[ggplot2]{geom_histogram}}.

ColPal & ColRev options are applied to both \code{fill} and \code{colour} scales. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.
}
\examples{
#Basic usage
plot_histogram(data = data_t_pratio, 
ycol = Cytokine, group = Genotype, 
BinSize = 10)
#with log transformation
plot_histogram(data = data_t_pratio, 
ycol = log(Cytokine), group = Genotype, 
BinSize = 10)
#Normalised counts
plot_histogram(data = data_t_pratio, 
ycol = log(Cytokine), group = Genotype, 
PlotType = "Normalised counts", 
BinSize = 10)
}
