% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescent.MainFunction.R
\name{gradDescent.predict}
\alias{gradDescent.predict}
\title{the gradDescent prediction stage}
\usage{
gradDescent.predict(gradDescent.model, gradDescent.data)
}
\arguments{
\item{gradDescent.model}{a object that created exclusively from
gradDescent.learn function}

\item{gradDescent.data}{a object that created exclusively from 
gradDescent.preprocessing function.}
}
\description{
This is the last of main function to predict the data test in gradDescent.data.
Input data in data test will be predicted using user-given input of model that
created exclusively from gradDescent.learn function. The predicted value will be
merged with the input data and denormalized to reveal the original value. This
function also calculate the error rate of the predicted data using Mean-Square-
Error and Root-Mean-Square-Error. Finaly, predicted data and error rate will be 
wrapped into a class.
}
\examples{
##################################
## I. Predict using gradient descent model
square_feet <- c(1400,1600,1700,1875,1100,1550,2350,2450,1425,1700)

price <- c(245,312,279,308,199,219,405,324,319,255)

house_price <- data.frame(square_feet, price)

## do the preprocessing stage
house_price.data <- gradDescent.preprocessing(
      house_price,
      normalizationMethod="variance"
   )

## do the model building stage
GD.model <- gradDescent.learn(
      house_price.data,
      methodType="GD" 
   )
## predict data
GD.predict <- gradDescent.predict(
      GD.model,
      house_price.data
   )
## view predicted value
print(GD.predict$predictionData)

## view mse and rmse error
print(GD.predict$mse)
print(GD.predict$rmse)

}

