% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-gpuVector.R,
%   R/methods-vclVector.R
\docType{methods}
\name{slice}
\alias{slice}
\alias{slice,gpuVector,integer,integer-method}
\alias{slice,vclVector,integer,integer-method}
\title{Vector Slices}
\usage{
slice(object, start, end)

\S4method{slice}{gpuVector,integer,integer}(object, start, end)

\S4method{slice}{vclVector,integer,integer}(object, start, end)
}
\arguments{
\item{object}{A \code{gpuVector} or \code{vclVector} object}

\item{start}{An integer indicating the start of slice}

\item{end}{An integer indicating the end of slice}
}
\value{
A \code{gpuVectorSlice} or \code{vclVectorSlice} object
}
\description{
This doesn't create a copy, it provides a child class that
points to a contiguous subvector of a \code{\link{gpuVector}} or
\code{\link{vclVector}}.  Non-contiguous slices are currently not supported.
}
\details{
This function allows a user to create a gpuR vector object that
references a continous subset of columns and rows of another gpuR vector
object without a copy.  

NOTE - this means that altering values in a vector slice object will alter
values in the source vector.
}
\author{
Charles Determan Jr.
}

