% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addin_chatgpt.R
\name{run_app_as_bg_job}
\alias{run_app_as_bg_job}
\title{Run an R Shiny app in the background}
\usage{
run_app_as_bg_job(appDir = ".", job_name, host, port)
}
\arguments{
\item{appDir}{The application to run. Should be one of the following:
\itemize{
\item A directory containing \code{server.R}, plus, either \code{ui.R} or
a \code{www} directory that contains the file \code{index.html}.
\item A directory containing \code{app.R}.
\item An \code{.R} file containing a Shiny application, ending with an
expression that produces a Shiny app object.
\item A list with \code{ui} and \code{server} components.
\item A Shiny app object created by \code{\link[shiny:shinyApp]{shinyApp()}}.
}}

\item{job_name}{The name of the background job to be created}

\item{host}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not. See
Details.}

\item{port}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port between 3000:8000, excluding ports that are blocked
by Google Chrome for being considered unsafe: 3659, 4045, 5060,
5061, 6000, 6566, 6665:6669 and 6697. Up to twenty random
ports will be tried.}
}
\value{
This function returns nothing because is meant to run an app as a
side effect.
}
\description{
This function runs an R Shiny app as a background job using the specified
directory, name, host, and port.
}
