% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{gost}
\alias{gost}
\title{Gene list functional enrichment.}
\usage{
gost(query, organism = "hsapiens", ordered_query = FALSE,
  multi_query = FALSE, significant = TRUE, exclude_iea = FALSE,
  measure_underrepresentation = FALSE, evcodes = FALSE,
  user_threshold = 0.05, correction_method = c("g_SCS", "bonferroni",
  "fdr", "false_discovery_rate", "gSCS", "analytical"),
  domain_scope = c("annotated", "known", "custom"), custom_bg = NULL,
  numeric_ns = "", sources = NULL)
}
\arguments{
\item{query}{vector, or a (named) list of vectors for multiple queries, that can consist of mixed types of gene IDs (proteins, transcripts, microarray IDs, etc), SNP IDs, chromosomal intervals or term IDs.}

\item{organism}{organism name. Organism names are constructed by concatenating the first letter of the name and the
family name. Example: human - 'hsapiens', mouse - 'mmusculus'.}

\item{ordered_query}{in case input gene lists are ranked this option may be
used to get GSEA style p-values.}

\item{multi_query}{in case of multiple gene lists, returns comparison table of these lists.
If enabled, the result data frame has columns named 'p_values', 'query_sizes', 'intersection_sizes' with vectors showing values in the order of input queries.
To get the results in a long format set 'multi_query' to FALSE and just input query list of multiple gene vectors.}

\item{significant}{whether all or only statistically significant results should
be returned.}

\item{exclude_iea}{exclude GO electronic annotations (IEA).}

\item{measure_underrepresentation}{measure underrepresentation.}

\item{evcodes}{include evidence codes to the results. Note
that this can decrease performance and make the query slower.
In addition, a column 'intersection' is created that contains the gene id-s that intersect between the query and term.
This parameter does not work if 'multi_query' is set to TRUE.}

\item{user_threshold}{custom p-value threshold, results with a larger p-value are
excluded.}

\item{correction_method}{the algorithm used for multiple testing correction, one of "gSCS" (synonyms: "analytical", "g_SCS"), "fdr" (synonyms: "false_discovery_rate"), "bonferroni".}

\item{domain_scope}{how to define statistical domain, one of "annotated", "known" or "custom".}

\item{custom_bg}{vector of gene names to use as a statistical background. If given, the domain_scope is set to 'custom'.}

\item{numeric_ns}{namespace to use for fully numeric IDs.}

\item{sources}{a vector of data sources to use. Currently, these include
GO (GO:BP, GO:MF, GO:CC to select a particular GO branch), KEGG, REAC, TF,
MIRNA, CORUM, HP, HPA, WP. Please see the g:GOSt web tool for the comprehensive
list and details on incorporated data sources.}
}
\value{
A named list where 'result' contains data.frame with the enrichment analysis results and 'meta' contains metadata needed for Manhattan plot. If the input
 consisted of several lists the corresponding list is indicated with a variable
 'query'.
 When requesting a 'multi_query', either TRUE or FALSE, the columns of the resulting data frame differ.
 If 'evcodes' is set, the return value includes columns 'evidence_codes' and 'intersection'.
 The latter conveys info about the intersecting genes between the corresponding query and term.

 The result fields are further described in \url{https://biit.cs.ut.ee/gprofiler_beta/page/apis#gost_query_results}
}
\description{
Interface to the g:Profiler tool g:GOSt (\url{https://biit.cs.ut.ee/gprofiler/gost}) for functional enrichments analysis of gene lists.
In case the input 'query' is a list of gene vectors, results for multiple queries will be returned in the same data frame with column 'query' indicating the corresponding query name.
If 'multi_query' is selected, the result is a data frame for comparing multiple input lists,
just as in the web tool.
}
\examples{
gostres <- gost(c("X:1000:1000000", "rs17396340", "GO:0005005", "ENSG00000156103", "NLRP1"))

}
\author{
Liis Kolberg <liis.kolberg@ut.ee>, Uku Raudvere <uku.raudvere@ut.ee>
}
