% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_validation.R
\name{crossvalidate}
\alias{crossvalidate}
\title{Cross-validation.}
\usage{
crossvalidate(gpModel, foldVector)
}
\arguments{
\item{gpModel}{object of class GPPM.}

\item{foldVector}{integer vector. Describes the foldstructure to use. For example, created by \code{\link{createLeavePersonsOutFolds}}.}
}
\value{
Cross-validation estimates of the mean squared error (MSE) and the negative log-predictive probability (nLPP)
}
\description{
Performs cross-validation of a Gaussian process panel model.
}
\details{
The fold vector, must be a vector of length nrow(getData(gpModel)) of integers from 1 to k. If \code{foldVector[i]=j}, then data point i is assigned to fold j.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
theFolds <- createLeavePersonsOutFolds(lgcm, k = 2) # for speed, in practive rather use default k=10
crosRes <- crossvalidate(lgcm, theFolds)
crosRes$MSE # mean squared error
crosRes$nLPP # negative log-predictive probability
}
}
