% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/governor.R
\name{gov_wait}
\alias{gov_wait}
\title{Wait an appropriate amount of time within a for-loop to match the desired
interval set in \code{gov}}
\usage{
gov_wait(gov)
}
\arguments{
\item{gov}{object created by \code{gov_init()}}
}
\value{
Logical value.  If \code{TRUE} then the governor is suggesting that
        the work for next loop be skipped if the loop interval is to 
        be maintained in the long term.
}
\description{
Wait an appropriate amount of time within a for-loop to match the desired
interval set in \code{gov}
}
\examples{
# This loop should take approx 1 second
gov <- gov_init(1/30)  # interval = 0.0333 seconds
system.time({
  for (i in 1:30) {
    Sys.sleep(0.01) # Work done in loop
    gov_wait(gov)   # Compensate to keep interval loop time
  }
})
}
