% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worst_regret.R
\name{worst_regret}
\alias{worst_regret}
\title{Worst regret in regret-based models from recursive partitioning trees}
\usage{
worst_regret(object, ...)
}
\arguments{
\item{object}{an object of class \code{party}}

\item{...}{further arguments passed to methods}
}
\value{
A data frame with regret estimates
\item{items}{the item names}
\item{worth}{the worth parameters}
\item{worst_regret}{the worst regret}
\item{regret}{the squared regret}
}
\description{
Compute a worst regret index from recursive partitioning trees. 
Regret is an important heuristic in the behavioural sciences. 
Minimizing worst regret (the loss under the worst possible 
outcome) is a criterion that takes a conservative approach 
to risk analysis in diversification strategies.
}
\examples{

library("PlackettLuce")
data("breadwheat", package = "gosset")

# convert the tricot rankings from breadwheat data
# into a object of class 'grouped_rankings'

G <- rank_tricot(breadwheat,
                 items = c("variety_a","variety_b","variety_c"),
                 input = c("overall_best","overall_worst"),
                 group = TRUE)


# combine grouped rankings with temperature indices
mydata <- cbind(G, breadwheat[c("lon","lat")])

# fit a pltree model using geographic data
mod <- pltree(G ~ ., data = mydata)

worst_regret(mod)


}
\references{
Loomes G. & Sugden R. (1982). 
The Economic Journal, 92(368), 805. 
\doi{https://doi.org/10.2307/2232669}

Bleichrodt H. & Wakker P. P. (2015). 
The Economic Journal, 125(583), 493–532. 
\doi{https://doi.org/10.1111/ecoj.12200}
}
\author{
Jacob van Etten and Kauê de Sousa
}
