% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory.R
\name{goose_delete}
\alias{goose_delete}
\title{Delete Object from Goose Memory}
\usage{
goose_delete(name, category = "r_objects", global = TRUE, confirm = TRUE)
}
\arguments{
\item{name}{Character string. Name of the object to delete}

\item{category}{Character string. Category where the object was saved (default: "r_objects")}

\item{global}{Logical. If TRUE (default), deletes from global memory. If FALSE, deletes from project-local memory.}

\item{confirm}{Logical. If TRUE (default), asks for confirmation before deleting.}
}
\value{
Invisibly returns TRUE if successful
}
\description{
Remove a saved R object from Goose's memory system.
}
\examples{
\dontrun{
# Delete an object
goose_delete("old_model", category = "models")

# Delete without confirmation
goose_delete("temp_data", confirm = FALSE)
}
}
