% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_urls.R
\name{google_map_directions}
\alias{google_map_directions}
\title{Google Map Directions}
\usage{
google_map_directions(origin = NULL, origin_place_id = NULL,
  destination = NULL, destination_place_id = NULL, travel_mode = NULL,
  dir_action = NULL, waypoints = NULL, waypoint_place_ids = NULL)
}
\arguments{
\item{origin}{string of an address or search term, or vector of lat/lon coordinates}

\item{origin_place_id}{a Google place id (\url{https://developers.google.com/places/place-id}).
If used, you must also specify an \code{origin}}

\item{destination}{string of an address or vector of lat/lon coordinates}

\item{destination_place_id}{a Google place id (\url{https://developers.google.com/places/place-id}).
If used, you must also specify an \code{destination}}

\item{travel_mode}{one of \code{driving}, \code{walking}, \code{bicycling} or
\code{transit}. If not supplied, the Google Map will show one or more of the
most relevant modes for the route.}

\item{dir_action}{can only be "navigate". If set, the map will attempt to launch turn-by-turn navigation
or route preview to the destination.}

\item{waypoints}{List of either place names, addresses, or \code{vectors} of lat/lon coordinates.
Up to 3 are allowed on mobile devices, and up to 9 otherwise.}

\item{waypoint_place_ids}{vector of \code{place_id}s to match against the list of \code{waypoints}.
If used, the \code{waypoints} must also be used.}
}
\description{
Opens Google Maps in a browser with the resutls of the specified directions query
}
\note{
There is no need for an api key

Waypoints are not supported on all Google Map products. In those cases, this parameter
will be ignored.
}
\examples{
\dontrun{

google_map_directions(origin = "Google Pyrmont NSW",
  destination = "QVB, Sydney", destination_place_id = "ChIJISz8NjyuEmsRFTQ9Iw7Ear8",
  travel_mode = "walking")


google_map_directions(origin = "Melbourne Cricket Ground",
  destination = "Flinders Street Station",
  dir_action = "navigate")

google_map_directions(origin = "Melbourne Cricket Ground",
  destination = "Flinders Street Station",
  travel_mode = "walking",
  waypoints = list("National Gallery of Victoria", c(-37.820860, 144.961894)))


google_map_directions(origin = "Paris, France",
  destination = "Cherbourg, France",
  travel_mode = "driving",
  waypoints = list("Versailles, France", "Chartres, France", "Le Mans, France",
    "Caen, France"))


google_map_directions(origin = "Paris, France",
  destination = "Cherbourg, France",
  travel_mode = "driving",
  waypoints = list("Versailles, France", "Chartres, France", "Le Mans, France",
    "Caen, France"),
  waypoint_place_ids = list("ChIJdUyx15R95kcRj85ZX8H8OAU",
  "ChIJKzGHdEgM5EcR_OBTT3nQoEA", "ChIJG2LvQNCI4kcRKXNoAsPi1Mc", "ChIJ06tnGbxCCkgRsfNjEQMwUsc"))

}

}
