% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_simplify_cellfeed.R
\name{gs_simplify_cellfeed}
\alias{gs_simplify_cellfeed}
\title{Simplify data from the "cell feed"}
\usage{
gs_simplify_cellfeed(x, convert = TRUE, literal = TRUE, locale = NULL,
  trim_ws = NULL, na = NULL, notation = c("A1", "R1C1", "none"),
  col_names = NULL)
}
\arguments{
\item{x}{a data frame returned by \code{\link{gs_read_cellfeed}}}

\item{convert}{logical. Indicates whether to attempt to convert the result
vector from character to something more appropriate, such as logical,
integer, or numeric. If \code{TRUE}, result is passed through
\code{\link[readr:type_convert]{readr::type_convert}}; if \code{FALSE},
result will be character.}

\item{literal}{logical, indicating whether to work only with literal values
returned by the API or to consult alternate cell contents}

\item{locale, trim_ws, na}{Optionally, specify locale, the fate of leading or
trailing whitespace, or a character vector of strings that should become
missing values. Passed straight through to
\code{\link[readr:type_convert]{readr::type_convert}}.}

\item{notation}{character. The result vector can have names that reflect
which cell the data came from; this argument selects between the "A1" and
"R1C1" positioning notations. Specify "none" to suppress names.}

\item{col_names}{if \code{TRUE}, the first row of the input will be
interpreted as a column name and NOT included in the result; useful when
reading a single column or variable.}
}
\value{
a vector
}
\description{
In some cases, you do not want to convert the data retrieved from the cell
feed into a data frame via \code{\link{gs_reshape_cellfeed}}. Instead, you
want the data as an atomic vector. That's what this function does. Note that,
unlike \code{\link{gs_reshape_cellfeed}}, embedded empty cells will NOT
necessarily appear in this result. By default, the API does not transmit data
for these cells; \code{googlesheets} inserts these cells in
\code{\link{gs_reshape_cellfeed}} because it is necessary to give the data
rectangular shape. In contrast, empty cells will only appear in the output of
\code{gs_simplify_cellfeed} if they were already present in the data from the
cell feed, i.e. if the original call to \code{\link{gs_read_cellfeed}} had
argument \code{return_empty} set to \code{TRUE}.
}
\examples{
\dontrun{
gap_ss <- gs_gap() # register the Gapminder example sheet
(gap_cf <- gs_read_cellfeed(gap_ss, range = cell_rows(1)))
gs_simplify_cellfeed(gap_cf)
gs_simplify_cellfeed(gap_cf, notation = "R1C1")

(gap_cf <- gs_read_cellfeed(gap_ss, range = "A1:A10"))
gs_simplify_cellfeed(gap_cf)
gs_simplify_cellfeed(gap_cf, col_names = FALSE)

ff_ss <- gs_ff() # register example sheet with formulas and formatted nums
ff_cf <- gs_read_cellfeed(ff_ss, range = cell_cols(3))
gs_simplify_cellfeed(ff_cf)                  # rounded to 2 digits
gs_simplify_cellfeed(ff_cf, literal = FALSE) # hello, more digits!
}

}
\seealso{
Other data consumption functions: \code{\link{gs_read_cellfeed}},
  \code{\link{gs_read_csv}},
  \code{\link{gs_read_listfeed}}, \code{\link{gs_read}},
  \code{\link{gs_reshape_cellfeed}}
}

