% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buckets.R
\name{gcs_update_bucket}
\alias{gcs_update_bucket}
\title{Update a bucket}
\usage{
gcs_update_bucket(bucket, new_name = NULL, ifMetagenerationMatch = NULL,
  ifMetagenerationNotMatch = NULL, location = NULL,
  storageClass = c("STANDARD", "NEARLINE", "DURABLE_REDUCED_AVAILABILITY"),
  predefinedAcl = c("authenticatedRead", "private", "projectPrivate",
  "publicRead", "publicReadWrite"),
  predefinedDefaultObjectAcl = c("authenticatedRead", "private",
  "projectPrivate", "publicRead", "publicReadWrite"), projection = c("noAcl",
  "full"))
}
\arguments{
\item{bucket}{Name of the bucket}

\item{new_name}{Globally unique name of bucket}

\item{ifMetagenerationMatch}{Return only if metageneration matches}

\item{ifMetagenerationNotMatch}{Return only if metageneration does not match}

\item{location}{Location of bucket. See details}

\item{storageClass}{Type of bucket}

\item{predefinedAcl}{Apply predefined access controls to bucket}

\item{predefinedDefaultObjectAcl}{Apply predefined access controls to objects}

\item{projection}{Properties to return. Default noAcl omits acl properties}
}
\description{
Update a buckets metadata
}
\details{
\href{https://cloud.google.com/storage/docs/bucket-locations}{See here for details on location options}

todo: acl, cors, lifecycle, logging, versioning, website
}
\seealso{
Other bucket functions: \code{\link{gcs_create_bucket}},
  \code{\link{gcs_get_bucket}},
  \code{\link{gcs_list_buckets}}
}

