% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{googleAuth}
\alias{googleAuth}
\title{Server side google auth (Shiny Module)}
\usage{
googleAuth(input, output, session, login_text = "Login via Google",
  logout_text = "Logout", login_class = "btn btn-primary",
  logout_class = "btn btn-default", access_type = c("online", "offline"),
  approval_prompt = c("auto", "force"), revoke = FALSE)
}
\arguments{
\item{input}{shiny input}

\item{output}{shiny output}

\item{session}{shiny session}

\item{login_text}{What the login text will read on the button}

\item{logout_text}{What the logout text will read on the button}

\item{login_class}{The CSS class for the login link}

\item{logout_class}{The CSS class for the logout link}

\item{access_type}{Online or offline access for the authentication URL}

\item{approval_prompt}{Whether to show the consent screen on authentication}

\item{revoke}{If TRUE a user on logout will need to re-authenticate}
}
\value{
A reactive authentication token
}
\description{
Server part of shiny module, use with \link{googleAuthUI}
}
\details{
Call via \code{shiny::callModule(googleAuth, "your_ui_name", login_text = "Login")}
}
\examples{

\dontrun{
options("googleAuthR.scopes.selected" = 
  c("https://www.googleapis.com/auth/urlshortener"))

shorten_url <- function(url){
  body = list(
    longUrl = url
 )
 
 f <- 
   gar_api_generator("https://www.googleapis.com/urlshortener/v1/url",
                     "POST",
                     data_parse_function = function(x) x$id)
                        
 f(the_body = body)
 
 }

server <- function(input, output, session){

  ## Create access token and render login button
  access_token <- callModule(googleAuth, 
                             "loginButton",
                             login_text = "Login1")

  short_url_output <- eventReactive(input$submit, {
    ## wrap existing function with_shiny
    ## pass the reactive token in shiny_access_token
    ## pass other named arguments
    with_shiny(f = shorten_url, 
               shiny_access_token = access_token(),
               url=input$url)
  })

  output$short_url <- renderText({

    short_url_output()

  })

}

## ui
ui <- fluidPage(
  googleAuthUI("loginButton"),
  textInput("url", "Enter URL"),
  actionButton("submit", "Shorten URL"),
  textOutput("short_url")
)

shinyApp(ui = ui, server = server)
}

}
\seealso{
Other shiny module functions: \code{\link{googleAuthUI}}
}
