% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments.R
\name{segment_ga4}
\alias{segment_ga4}
\title{Make a segment object for use}
\usage{
segment_ga4(name, segment_id = NULL, user_segment = NULL,
  session_segment = NULL)
}
\arguments{
\item{name}{The name of the segment for the reports.}

\item{segment_id}{The segment ID of a built in or custom segment e.g. gaid::-3}

\item{user_segment}{A list of \code{segment_define}'s that apply to users}

\item{session_segment}{A list of \code{segment_define}'s that apply to sessions}
}
\value{
a segmentFilter object. You can pass a list of these to the request.
}
\description{
A Segment is a subset of the Analytics data. 
For example, of the entire set of users, one Segment 
might be users from a particular country or city.
}
\details{
\code{segment_ga4} is the top hierarchy of segment creation, for which you will also need:
\itemize{
 \item \link{segment_define} : AND combination of segmentFilters
 \item \link{segment_vector_simple} or \link{segment_vector_sequence}
 \item \link{segment_element} that are combined in OR lists for \code{segment_vectors_*}
}
}
\examples{

\dontrun{
library(googleAnalyticsR)

## authenticate, 
## or use the RStudio Addin "Google API Auth" with analytics scopes set
ga_auth()

## get your accounts
account_list <- google_analytics_account_list()

## pick a profile with data to query

ga_id <- account_list[23,'viewId']


## make a segment element
se <- segment_element("sessions", 
                      operator = "GREATER_THAN", 
                      type = "METRIC", 
                      comparisonValue = 1, 
                      scope = "USER")
                      
                      
se2 <- segment_element("medium", 
                       operator = "EXACT", 
                       type = "DIMENSION", 
                       expressions = "organic")
                       
                       
## choose between segment_vector_simple or segment_vector_sequence
## Elements can be combined into clauses, which can then be 
##    combined into OR filter clauses
sv_simple <- segment_vector_simple(list(list(se)))

sv_simple2 <- segment_vector_simple(list(list(se2)))

## Each segment vector can then be combined into a logical AND

seg_defined <- segment_define(list(sv_simple, sv_simple2))

## if only one AND definition, you can leave out wrapper list()

seg_defined_one <- segment_define(sv_simple)

## Each segement defintion can apply to users, sessions or both.
## You can pass a list of several segments

segment4 <- segment_ga4("simple", user_segment = seg_defined)
## Add the segments to the segments param

segment_example <- google_analytics(ga_id, 
                                    c("2015-07-30","2015-10-01"), 
                                    dimensions=c('source','medium','segment'), 
                                    segments = segment4, 
                                    metrics = c('sessions','bounces')
                                     )
                                     
                                     
## Sequence segment

se2 <- segment_element("medium", 
                       operator = "EXACT", 
                       type = "DIMENSION", 
                       expressions = "organic")
                       
se3 <- segment_element("medium",
                       operator = "EXACT",
                       type = "DIMENSION",
                       not = TRUE,
                      expressions = "organic")
                      
## step sequence
## users who arrived via organic then via referral
sv_sequence <- segment_vector_sequence(list(list(se2), 
                                            list(se3)))
                                            
seq_defined2 <- segment_define(list(sv_sequence))

segment4_seq <- segment_ga4("sequence", user_segment = seq_defined2)

## Add the segments to the segments param

segment_seq_example <- google_analytics(ga_id, 
                                        c("2016-04-01","2016-05-01"), 
                                        dimensions=c('source','segment'), 
                                        segments = segment4_seq,
                                        metrics = c('sessions','bounces')
                                         )
                                     
}

}
\seealso{
Other v4 segment functions: \code{\link{segment_define}},
  \code{\link{segment_element}},
  \code{\link{segment_vector_sequence}},
  \code{\link{segment_vector_simple}}
}
\concept{v4 segment functions}
