% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remarketingAudiences.R
\name{ga_remarketing_create}
\alias{ga_remarketing_create}
\title{Create a new remarketing audience}
\usage{
ga_remarketing_create(adwordsLinkId, include, exclude = NULL,
  audienceType = c("SIMPLE", "STATE_BASED"), name = NULL)
}
\arguments{
\item{adwordsLinkId}{The adwords link to add the remarketing audience to}

\item{include}{A \code{ga4_remarketing_segment} object to include via \link{ga_remarketing_build}}

\item{exclude}{If \code{audienceType="STATE_BASED"}, a \code{ga4_remarketing_segment} object to exclude via \link{ga_remarketing_build}}

\item{audienceType}{\code{SIMPLE} or \code{STATE_BASED}}

\item{name}{An optional name, if not supplied one will be generated}
}
\description{
Create a remarketing audiences built via \link{ga_remarketing_build}
}
\details{
This builds and calls the API to create the remarketing audience based on the segments you have defined.
}
\examples{

\dontrun{
adword_list <- ga_adwords_list(123456, "UA-123456-1")

adword_link <- ga_adword(adword_list$id[[1]])

segment_list <- ga_segment_list()$items$definition

my_remarketing1 <- ga_remarketing_build(segment_list[[1]], 
                    state_duration = "TEMPORARY",
                    membershipDurationDays = 90, 
                    daysToLookBack = 14)
                    
my_remarketing2 <- ga_remarketing_build(segment_list[[2]], 
                     state_duration = "PERMANENT",
                     membershipDurationDays = 7, 
                     daysToLookBack = 31)
                     
# state based only can include exclusions
ga_remarketing_create(adwords_link = adword_link,
                     include = my_remarketing1, 
                     exclude = my_remarketing2,
                     audienceType = "STATE_BASED", 
                     name = "my_remarketing_seg1")

}
}
\seealso{
Other remarketing management functions: \code{\link{ga_remarketing_build}},
  \code{\link{ga_remarketing_estimate}},
  \code{\link{ga_remarketing_get}},
  \code{\link{ga_remarketing_list}}
}
\concept{remarketing management functions}
