% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_opt.R
\name{get_golem_options}
\alias{get_golem_options}
\title{Get all or one golem options}
\usage{
get_golem_options(which = NULL)
}
\arguments{
\item{which}{NULL (default), or the name of an option}
}
\value{
The value of the option.
}
\description{
This function is to be used inside the
server and UI from your app, in order to call the
parameters passed to \code{run_app()}.
}
\examples{
\dontrun{

# Define and use golem_options

# 1. Pass parameters to `run_app`

# to set default value, edit run_app like this :
run_app <- function(
  title = "this",
  content = "that"
) {
  with_golem_options(
    app = shinyApp(
      ui = app_ui,
      server = app_server
    ),
    golem_opts = list(
      p1 = p1,
      p3 = p3
    )
  )
}

# 2. Get the values from the UI side

h1(get_golem_options("title"))

# 3. Get the value from the server-side

output$param <- renderPrint({
  paste("param p2 = ", get_golem_options("p2"))
})
}

}
