% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specresponse.R
\name{specresponse}
\alias{specresponse}
\title{Species response curves}
\usage{
specresponse(species, var, main, xlab, model = "unimodal", method = "env",
  axis = 1)
}
\arguments{
\item{species}{Vector containing species abundances (per plot).}

\item{var}{Vector containing environmental variable (per plot) \strong{OR} \code{vegan} ordination result object if \code{method = "ord"}.}

\item{main}{Optional: Main title.}

\item{xlab}{Optional: Label of x-axis.}

\item{model}{Defining the assumed species response: Default \code{method = "unimodal"} fits a unimodal response. Other methods are \code{method = "linear"} (linear response), \code{method = "bimodal"} (bimodal response), \code{method = "auto"} (automatic selection based on AIC) and \code{method = "gam"} (using GAM with smoother)}

\item{method}{Method defining the type of variable. Default \code{method = "env"} fits a response curve to environmental variables. Alternatively \code{method = "ord"} fits a response along an ordination axis.}

\item{axis}{Ordination axis (only if \code{method = "ord"}).}
}
\value{
Returns an (invisible) object containing the model results
}
\description{
This function fits species response curves to visalize a species response to environmental gradients or ordination axes.
It is based on Logistic Regression using Generalised Linear Models (GLMs) or Generalized Additive Models (GAMs) with integrated smoothness estimation.
For drawing multiple curves into one plot use \code{\link{specresponses}}.
}
\section{Details}{

For response curves based on environmental variable gradients the argument \code{var} takes a single vector containing the variable corresponding to the species abundances. The direct response of a species to the environmental variable is shown.

For a response to ordination axis (\code{method = "ord"}) the argument \code{var} requires a \code{vegan} ordination result object (e.g. from \code{\link[vegan]{decorana}}, \code{\link[vegan]{cca}}, \code{\link[vegan]{rda}} or \code{\link[vegan]{metaMDS}}).
Response of species to axis is shown; note that meaning of axis differ in unconstrained and constrained methods.
First axis is used as default.
}
\examples{
## Draw species response curve on environmental variable
specresponse(schedenveg$ArrElat, schedenenv$soil_depth)

## Draw species response curve on environmental variable with
## custom labels
specresponse(schedenveg$ArrElat, schedenenv$soil_depth, main = "Arrhenatherum elatius",
       xlab = "Soil depth")

## Draw species response curve on ordination axes
## First calculate DCA
library(vegan)
scheden.dca <- decorana(schedenveg)

# Using a linear model on first axis
specresponse(schedenveg$ArrElat, scheden.dca, method = "ord", model = "linear")
# Using an unimodal model on second axis
specresponse(schedenveg$ArrElat, scheden.dca, method = "ord", axis = 2)
}
\author{
Friedemann Goral (\email{fgoral@gwdg.de}) and Jenny Schellenberg
}
\seealso{
\code{\link{specresponses}}
}

