% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env_interaction_CaseControl_model.R
\name{env_interaction_CC.calc}
\alias{env_interaction_CC.calc}
\title{Variant-Environmental interaction effects on a case control variable}
\usage{
env_interaction_CC.calc(
  cc,
  g,
  env,
  yob = rep(-1, length(cc)),
  sex = rep(-1, length(cc)),
  round_imputed = FALSE,
  dominance_term = FALSE,
  square_env = FALSE,
  covariates = as.data.frame(matrix(0, nrow = 0, ncol = 0))
)
}
\arguments{
\item{cc}{A numeric vector}

\item{g}{A vector with (possibly imputed) genotype values. All entries should be larger than 0 and smaller than 2.}

\item{env}{A numeric vector with an environmental variable}

\item{yob}{A numerical vector containing year of birth. If some are unknown they should be marked as -1}

\item{sex}{A numerical vector containing sex, coded 0 for males, 1 for females and -1 for unknown}

\item{round_imputed}{A boolian variable determining whether imputed genotype values should be rounded to the nearest integer in the analysis.}

\item{dominance_term}{A boolian variable determining whether a dominance term for the variant should be included as a covariates in the analysis}

\item{square_env}{A boolian variable determining whether the square of the environmental trait should be included as a covariate in the analysis}

\item{covariates}{A dataframe containing any other covariates that should be used; one column per covariate}
}
\value{
A list with the environmental interaction effect and corresponding standard error, t statistic and p-value
}
\description{
This function estimates the interaction effect of a genetic variant with an environmental factor on a case control variable
We apply a simple logistic regression model to estimate interaction effects.
We include a linear term for the variant and environmental variable seperately.
The variant is coded as 0,1 and 2 for non-carriers, heterozygotes and homozygous carriers of the effect allele.
The environmental variable is rank-normalized automatically as part of the function.
The interaction term is defined as the product of the genetic and the (normalized) environmental variable.
Effect size and significance is based on the interaction term.
}
\examples{
g_vec <- rbinom(100000, 2, 0.9)
env_vec <- round(runif(100000, min = 0, max = 6))
cc_vec <- rbinom(100000,1,0.1 * (1.05^g_vec) *
          (1.1^env_vec)* (1.1 ^ (g_vec * env_vec)))
res <- env_interaction_CC.calc(cc_vec, g_vec, env_vec)
}
