% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wvar_cpp}
\alias{wvar_cpp}
\title{Computes the (MODWT) wavelet variance}
\usage{
wvar_cpp(signal_modwt, robust = FALSE, eff = 0.6, alpha = 0.05,
  ci_type = "eta3", strWavelet = "haar")
}
\arguments{
\item{signal_modwt}{A \code{field<vec>} that contains the modwt decomposition.}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}

\item{alpha}{A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level}

\item{ci_type}{A \code{String} indicating the confidence interval being calculated. Valid value: "eta3"}

\item{strWavelet}{A \code{String} indicating the type of wave filter to be applied. Must be "haar"}
}
\value{
A \code{mat} with the structure:
\itemize{
  \item{"variance"}{Wavelet Variance}
  \item{"low"}{Lower CI}
  \item{"high"}{Upper CI}
}
}
\description{
Calculates the (MODWT) wavelet variance
}
\details{
This function powers the wvar object. It is also extendable...
}
\examples{
x=rnorm(100)
decomp = modwt(x)
wvar_cpp(decomp$data, robust = FALSE)
}
\keyword{internal}

