% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imu.R
\name{imu}
\alias{imu}
\title{Create an IMU Object}
\usage{
imu(object, gyroscope = NULL, accelerometer = NULL, axis = NULL)
}
\arguments{
\item{object}{A \code{vector} which contains data, or a \code{matrix} or \code{data.frame} which contains the data in each column.}

\item{gyroscope}{A \code{vector} that contains the index of columns where gyroscope data (such as Gyro. X, Gyro. Y and Gyro. Z) is placed.}

\item{accelerometer}{A \code{vector} that contains the index of columns where accelerometer data (such as Accel. X, Accel. Y and Accel. Z) is placed.}

\item{axis}{A \code{vector} that indicates the axises, such as 'X', 'Y', 'Z'.}
}
\value{
An \code{imu} object in the following structure:
\itemize{
  \item{data:} {A \code{matirx} that contains gyroscope and accelerometer data.}
  \item{sensor:} {A \code{vector} that indicates whether data contains gyroscope sensor, accelerometer sensor, or both.}
  \item{num.sensor:} {A \code{vector} that indicates how many columns of data are for gyroscope sensor and accelerometer sensor.}
  \item{axis:} {axis value such as 'X', 'Y', 'Z'.}
}
}
\description{
Builds an IMU object that provides the program with gyroscope, accelerometer, and axis information per column in the dataset.
}
\details{
\code{object} can be a numeric vector, matrix or data frame.

\code{gyroscope} and \code{accelerometer} cannot be \code{NULL} at the same time, but it will be fine if one of them is \code{NULL}.
Also, in order to plot the graph, the length of \code{gyroscope} and \code{accelerometer} are restricted to be equal.

In \code{axis}, duplicate elements are not alowed. If one of parameters between \code{gyroscope} and \code{accelerometer}
is \code{NULL}, specify the axis for each column of data. Check example 1 for help. If both of them are not \code{NULL}, specify the
\code{axis} only for one parameter (\code{gyroscope} or \code{accelerometer}). Check example 2 for help.

\code{axis} will be automatically generated if there are less than or equal to 3 axises.
}
\examples{
\dontrun{
if(!require("imudata")){
   install_imudata()
   library("imudata")
}

data(imu6)

# Example 1
test1 = imu(imu6, gyroscope = 1:3, accelerometer = NULL, axis = c('X', 'Y', 'Z'))
df1 = wvar.imu(test1)
plot(df1)

# Example 2
test2 = imu(imu6, gyroscope = 1:2, accelerometer = NULL, axis = c('X', 'Y'))
df2 = wvar.imu(test2)
plot(df2)

# Example 3
test3 = imu(imu6, gyroscope = 1:3, accelerometer = 4:6, axis = c('X', 'Y', 'Z'))
df3 = wvar.imu(test3)
plot(df3)

# Example 4
test4 = imu(imu6, gyroscope = 1:2, accelerometer = 4:5, axis = c('X', 'Y'))
df4 = wvar.imu(test4)
plot(df4)}
}
\author{
JJB, Wenchao
}

