% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_lts}
\alias{gen_lts}
\title{Generate Latent Time Series based on Model (Internal)}
\usage{
gen_lts(N, theta, desc, objdesc)
}
\arguments{
\item{N}{An \code{interger} containing the amount of observations for the time series.}

\item{theta}{A \code{vec} containing the parameters to use to generate the model.}

\item{desc}{A \code{vector<string>} containing the different model types (AR1, WN, etc..).}

\item{objdesc}{A \code{field<vec>} containing the different model objects e.g. AR1 = c(1,1)}
}
\value{
A \code{mat} containing data for each decomposed and combined time series.
}
\description{
Create a latent time series based on a supplied time series model.
}
\examples{
# AR
set.seed(1336)
gen_lts(1000, c(.9,1), "AR1", list(c(1,1)))
}
\keyword{internal}

