% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickParams.R
\name{get_omega_eigens}
\alias{get_omega_eigens}
\title{Calculate the eigenvalues of the "Omega" error term covariance matrices}
\usage{
get_omega_eigens(gmvar)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}
}
\value{
Returns a matrix with \eqn{d} rows and \eqn{M} columns - one column for each regime.
 The \eqn{m}th column contains the eigenvalues of the "Omega" error term covariance matrix
 of the \eqn{m}th regime.
}
\description{
\code{get_omega_eigens} calculates the eigenvalues of the "Omega" error
 term covariance matrices for each mixture component.
}
\examples{
params222 <- c(-11.904, 154.684, 1.314, 0.145, 0.094, 1.292, -0.389,
 -0.070, -0.109, -0.281, 0.920, -0.025, 4.839, 11.633, 124.983, 1.248,
  0.077, -0.040, 1.266, -0.272, -0.074, 0.034, -0.313, 5.855, 3.570,
  9.838, 0.740)
mod222 <- GMVAR(d=2, p=2, M=2, params=params222, parametrization="mean")
get_omega_eigens(mod222)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
