% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_ug.R
\name{ug-constrained correlation matrices}
\alias{ug-constrained correlation matrices}
\alias{port}
\alias{port_chol}
\alias{diagdom}
\title{Simulation of correlation matrices.}
\usage{
port(N = 1, p = 3, d = 1, ug = NULL, zapzeros = TRUE,
  rfun = rnorm, ...)

port_chol(N = 1, p = 3, d = 1, ug = NULL, zapzeros = TRUE, ...)

diagdom(N = 1, p = 3, d = 1, ug = NULL, rfun = rnorm, ...)
}
\arguments{
\item{N}{Number of samples.}

\item{p}{Matrix dimension. Ignored if \code{ug} is provided.}

\item{d}{Number in \code{[0,1]}, the proportion of non-zero
entries in the sampled matrices. Ignored if \code{ug} is provided.}

\item{ug}{An igraph undirected graph specifying the zero pattern in the sampled matrices.}

\item{zapzeros}{Boolean, convert to zero extremely low entries? Defaults to \code{TRUE}.}

\item{rfun}{Function that generates the random entries in the initial
factors, except for \code{\link[=port_chol]{port_chol()}} which uses \code{\link[=mh_u]{mh_u()}} to obtain it.}

\item{...}{Additional parameters to be passed to \code{rfun} or to
\code{\link[=mh_u]{mh_u()}}.}
}
\value{
A three-dimensional array of length \code{p x p x N}.
}
\description{
Sample correlation matrices, possibly with a zero pattern constrained by an
undirected graph.
}
\details{
Function \code{\link[=port]{port()}} uses the method described in
Córdoba et al. (2018). In summary, it consists on generating a random
matrix \code{Q} and performing row-wise orthogonalization such that if \code{i} and \code{j}
are not adjacent in \code{ug}, then the rows corresponding to such indices are
orthogonalized, without violating previous orthogonalizations and without
introducing unwanted independences. The resulting matrix after the process
has finished is the cross product of \code{Q}.

Function \code{\link[=port_chol]{port_chol()}} uses the method described in Córdoba et
al. (2019), combining uniform sampling with partial orthogonalization as
follows. If the graph provided is not chordal, then a chordal cover is found
using \code{\link[gRbase:triangulate]{gRbase::triangulate()}}. Then uniform sampling for the upper Choleksy
factor corresponding to such chordal cover is performed with \code{\link[=mh_u]{mh_u()}}.
Finally, it uses partial orthogonalization as \code{\link[=port]{port()}} to add the missing
zeros (corresponding to fill-in edges in the chordal cover). The behaviour of
this function is the same as \code{\link[=port]{port()}}.

We also provide an implementation of the most commonly used in the
literature \code{\link[=diagdom]{diagdom()}}. By contrast, this method produces a random matrix \code{M}
with zeros corresponding to missing edges in \code{ug}, and then enforces a
dominant diagonal to ensure positive definiteness. Matrices produced by
\code{diagdom} usually are better conditioned than those by \code{port}; however, they
typically suffer from small off-diagonal entries, which can compromise model
validation in Gaussian graphical models. This is avoided by \code{port}.
}
\examples{
## Partial orthogonalization
# Generate a full matrix (default behaviour)
port()

# Generate a matrix with a percentage of zeros
port(d = 0.5)
port(d = 0.5, zapzeros = FALSE) # no zero zap

# Generate a random undirected graph structure
ug <- rgraph(p = 3, d = 0.5)
igraph::print.igraph(ug)

# Generate a matrix complying with the predefined zero pattern
port(ug = ug)
port(ug = ug, zapzeros = FALSE) # no zero zap
## Diagonal dominance
# Generate a full matrix (default behaviour)
diagdom()

# Generate a matrix with a percentage of zeros
diagdom(d = 0.5)

# Generate a matrix complying with the predefined zero pattern
igraph::print.igraph(ug)
diagdom(ug = ug)
}
\references{
Córdoba, I., Varando, G., Bielza, C. and Larrañaga, P. A partial
orthogonalization method for simulation covariance and concentration graph
matrices. \emph{Proceedings of Machine Learning Research} (PGM 2018), vol. 72, pp.
61 - 72, 2018.

Córdoba, I., Varando, G., Bielza, C. and Larrañaga, P. Generating
random Gaussian graphical models_arXiv_:1909.01062, 2019.
}
