% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{messages}
\alias{messages}
\title{Get a list of messages}
\usage{
messages(search = NULL, num_results = NULL, label_ids = NULL,
  include_spam_trash = NULL, user_id = "me", page_token = NULL)
}
\arguments{
\item{search}{query to use, same format as gmail search box.}

\item{num_results}{the number of results to return.}

\item{label_ids}{restrict search to given labels}

\item{include_spam_trash}{boolean whether to include the spam and trash folders in the search}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}

\item{page_token}{retrieve a specific page of results}
}
\description{
Get a list of messages possibly matching a given query string.
}
\examples{
\dontrun{
#Search for R, return 10 results using label 1 including spam and trash folders
my_messages = messages("R", 10, "label_1", TRUE)
}
}
\references{
\url{https://developers.google.com/gmail/api/v1/reference/users/messages/list}
}

