% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{NGSAustralia}
\alias{NGSAustralia}
\title{National Geochemical Survey of Australia: soil data}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 5259 rows and 76 columns.
}
\source{
\url{https://www.ga.gov.au/about/projects/resources/national-geochemical-survey}
}
\usage{
NGSAustralia
}
\description{
A dataset containing the geochemical composition of soil samples covering approx 2/3
of Australia, at a spatial resolution of 1 sample/5000 $km^2$.
The original data is published by Geosciences Australia under the Creative
Commons CC4 Licence + Attribution (CC-BY-SA-4.0).
The provided data set has additional information and
some pre-treatment with respect to the one available in the references below. These changes:
}
\details{
\itemize{
\item Concentrations are all reported as mg/kg, also known as parts per million (ppm). Values below
detection limit are reported as minus the detection limit, as standardised in package
"compositions".
\item The samples were complemented with information about their belonging to one of the
major crustal blocks (MCB) of Australia.
\item Easting and Northing coordinates were computed using the Lambert conformal conic projection of
Australia (earth ellipsoid GRS80; standard parallels: 18S and 36S latitude; central meridian:
134E longitude).
}

#' @format A tibble, a data set of compound class c("tbl_df", "tbl", "data.frame") with 5259
observations and 76 variables:
\describe{
\item{ORDER}{Entry order}
\item{SITEID}{ID of the sampling site}
\item{DATE SAMPLED}{Timestamp of the sampling}
\item{EAST}{Easting coordinate of the sampling site}
\item{NORTH}{Northing coordinate of the sampling site}
\item{LATITUDE}{Latitude of the sampling site}
\item{LONGITUDE}{Longitude of the sampling site}
\item{STATE}{State of the sampling site, one of: "NWS" (New South Wales), "NT" (Northern Territory),
"QLD" (Qeensland), "SA" (Southern Australia), "TAS" (Tasmania), "VIC" (Victoria) or "WA" (Western Australia)}
\item{REGION}{One of the three geo-regions of the data set: "EAST", "WEST" or "EUCLA"}
\item{DUPLICATE CODE}{Marker for duplicate samples, for quality control}
\item{SAMPLEID}{ID of the sample}
\item{GRAIN SIZE}{Particle size of the soil sample, one of "<2 mm" (coarse) or "<75 um" (fine)}
\item{DEPTH}{Sampling depth, one of: "TOS" (top soil) or "BOS" (bottom soil)}
\item{CODE}{A combination of \verb{Grain Size} and \code{DEPTH}, one of "Tc" "Tf" "Bc" "Bf", standing for TOS coarse, TOS fine, BOS coarse and BOS fine, respectively}
\item{\verb{Ag ICP-MS mg/kg 0.03}}{concemtration of Silver in that sample, analysed with inductive coupled plasma mass spectrometry (ICP-MS), with a detection limit of 0.03ppm}
\item{\verb{Al XRF mg/kg 26}}{concentration of Aluminium, analysed with X-Ray Fluorescence (XRF), detection limit 26 ppm}
\item{\verb{As ICP-MS mg/kg 0.4}}{concentration of Arsenic measured with ICP-MS , detection limit: 0.4 mg/kg }
\item{\verb{Au FA mg/kg 0.001}}{concentration of Gold measured with fire assay (FA) , detection limit: 0.001 mg/kg }
\item{\verb{Ba ICP-MS mg/kg 0.5}}{concentration of Barium measured with ICP-MS , detection limit: 0.5 mg/kg }
\item{\verb{Be ICP-MS mg/kg 1.1}}{concentration of Berillium measured with ICP-MS , detection limit: 1.1 mg/kg }
\item{\verb{Bi ICP-MS mg/kg 0.02}}{concentration of Bismuth measured with ICP-MS , detection limit: 0.02 mg/kg }
\item{\verb{Ca XRF mg/kg 14}}{concentration of Calcium measured with XRF , detection limit: 14 mg/kg }
\item{\verb{Cd ICP-MS mg/kg 0.1}}{concentration of Cadmium measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{Ce ICP-MS mg/kg 0.03}}{concentration of Cerium measured with ICP-MS , detection limit: 0.03 mg/kg }
\item{\verb{Cl  XRF mg/kg 10}}{concentration of Chlorine measured with XRF , detection limit: 10 mg/kg}
\item{\verb{Co ICP-MS mg/kg 0.1}}{concentration of Cobalt measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{Cr ICP-MS mg/kg 0.5}}{concentration of Cromium measured with ICP-MS , detection limit: 0.5 mg/kg }
\item{\verb{Cs ICP-MS mg/kg 0.1}}{concentration of Caesium measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{Cu ICP-MS mg/kg 0.2}}{concentration of Copper measured with ICP-MS , detection limit: 0.2 mg/kg }
\item{\verb{Dy ICP-MS mg/kg 0.1}}{concentration of Dysprosium measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{Er ICP-MS mg/kg 0.03}}{concentration of Erbium measured with ICP-MS , detection limit: 0.03 mg/kg }
\item{\verb{Eu ICP-MS mg/kg 0.03}}{concentration of Europium measured with ICP-MS , detection limit: 0.03 mg/kg }
\item{\verb{F ISE mg/kg 20}}{concentration of Fluoride measured with Ion Selective Electrode (ISE), detection limit: 20 mg/kg }
\item{\verb{FeT XRF mg/kg 35}}{concentration of total Iron measured with XRF , detection limit: 35 mg/kg }
\item{\verb{Ga ICP-MS mg/kg 0.1}}{concentration of Gallium measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{Gd ICP-MS mg/kg 0.03}}{concentration of Gadolinium measured with ICP-MS , detection limit: 0.03 mg/kg }
\item{\verb{Ge ICP-MS mg/kg 0.04}}{concentration of Germanium measured with ICP-MS , detection limit: 0.04 mg/kg }
\item{\verb{Hf ICP-MS mg/kg 0.04}}{concentration of Hafnium measured with ICP-MS , detection limit: 0.04 mg/kg }
\item{\verb{Ho ICP-MS mg/kg 0.02}}{concentration of Holmium measured with ICP-MS , detection limit: 0.02 mg/kg }
\item{\verb{K XRF mg/kg 42}}{concentration of Potassium measured with XRF , detection limit: 42 mg/kg }
\item{\verb{La ICP-MS mg/kg 0.1}}{concentration of Lantanum measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{Lu ICP-MS mg/kg 0.02}}{concentration of Lutetium measured with ICP-MS , detection limit: 0.02 mg/kg }
\item{\verb{Mg XRF mg/kg 60}}{concentration of Magnesium measured with XRF , detection limit: 60 mg/kg }
\item{\verb{Mn XRF mg/kg 39}}{concentration of Manganese measured with XRF , detection limit: 39 mg/kg }
\item{\verb{Mo ICP-MS mg/kg 0.3}}{concentration of Molybdenum measured with ICP-MS , detection limit: 0.3 mg/kg }
\item{\verb{Na XRF mg/kg 74}}{concentration of Sodium measured with XRF , detection limit: 74 mg/kg }
\item{\verb{Nb ICP-MS mg/kg 0.03}}{concentration of Niobium measured with ICP-MS , detection limit: 0.03 mg/kg }
\item{\verb{Nd ICP-MS mg/kg 0.1}}{concentration of Neodymium measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{Ni ICP-MS mg/kg 0.5}}{concentration of Nickel measured with ICP-MS , detection limit: 0.5 mg/kg }
\item{\verb{P XRF mg/kg 22}}{concentration of Phosphorus measured with XRF , detection limit: 22 mg/kg }
\item{\verb{Pb ICP-MS mg/kg 0.1}}{concentration of Lead measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{Pd FA mg/kg 0.001}}{concentration of Palladium measured with FA , detection limit: 0.001 mg/kg }
\item{\verb{Pr ICP-MS mg/kg 0.02}}{concentration of Praseodymium measured with ICP-MS , detection limit: 0.02 mg/kg }
\item{\verb{Pt FA mg/kg 0.0005}}{concentration of Platinum measured with FA , detection limit: 0.0005 mg/kg }
\item{\verb{Rb ICP-MS mg/kg 0.2}}{concentration of Rubidium measured with ICP-MS , detection limit: 0.2 mg/kg }
\item{\verb{S XRF mg/kg 10}}{concentration of Sulphur measured with XRF , detection limit: 10 mg/kg }
\item{\verb{Sb ICP-MS mg/kg 0.4}}{concentration of Antimony measured with ICP-MS , detection limit: 0.4 mg/kg }
\item{\verb{Sc ICP-MS mg/kg 0.3}}{concentration of Scandium measured with ICP-MS , detection limit: 0.3 mg/kg }
\item{\verb{Si XRF mg/kg 47}}{concentration of Silicon measured with XRF , detection limit: 47 mg/kg }
\item{\verb{Sm ICP-MS mg/kg 0.04}}{concentration of Samarium measured with ICP-MS , detection limit: 0.04 mg/kg }
\item{\verb{Sn ICP-MS mg/kg 0.2}}{concentration of Tin measured with ICP-MS , detection limit: 0.2 mg/kg }
\item{\verb{Sr ICP-MS mg/kg 0.2}}{concentration of Strontium measured with ICP-MS , detection limit: 0.2 mg/kg }
\item{\verb{Ta ICP-MS mg/kg 0.02}}{concentration of Tantalum measured with ICP-MS , detection limit: 0.02 mg/kg }
\item{\verb{Tb ICP-MS mg/kg 0.02}}{concentration of Terbium measured with ICP-MS , detection limit: 0.02 mg/kg }
\item{\verb{Th ICP-MS mg/kg 0.02}}{concentration of Thorium measured with ICP-MS , detection limit: 0.02 mg/kg }
\item{\verb{Ti XRF mg/kg 30}}{concentration of Titanium measured with XRF , detection limit: 30 mg/kg }
\item{\verb{U ICP-MS mg/kg 0.02}}{concentration of Uranium measured with ICP-MS , detection limit: 0.02 mg/kg }
\item{\verb{V ICP-MS mg/kg 0.1}}{concentration of Vanadium measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{W ICP-MS mg/kg 0.1}}{concentration of Wolframium measured with ICP-MS , detection limit: 0.1 mg/kg }
\item{\verb{Y ICP-MS mg/kg 0.05}}{concentration of Yttrium measured with ICP-MS , detection limit: 0.05 mg/kg }
\item{\verb{Yb ICP-MS mg/kg 0.04}}{concentration of Ytterbium measured with ICP-MS , detection limit: 0.04 mg/kg }
\item{\verb{Zn ICP-MS mg/kg 0.9}}{concentration of Zink measured with ICP-MS , detection limit: 0.9 mg/kg }
\item{\verb{Zr ICP-MS mg/kg 0.2}}{concentration of Zirconium measured with ICP-MS , detection limit: 0.2 mg/kg }#'   \item{LOI CALC mg/kg}{concentration of Loss-on-Ignition, measured by calcination}
\item{\verb{LOI CALC mg/kg}}{concentration of Loss-On-Ignition measured with Calcination , detection limit: 0.2 mg/kg }#'   \item{LOI CALC mg/kg}{concentration of Loss-on-Ignition, measured by calcination}
\item{MRB}{obtained from simplifying the major crustal boundaries of {Korsch2015a, Korsch2015b}}
}
}
\section{License}{
 CC BY-SA 4.0
}

\keyword{datasets}
