% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmValidationStrategy.R
\name{NfoldCrossValidation}
\alias{NfoldCrossValidation}
\title{Specify a strategy for validation of a spatial model}
\usage{
NfoldCrossValidation(nfolds = 2, doAll = TRUE, ...)
}
\arguments{
\item{nfolds}{Either, one integer between 2 and the number of hard conditioning data,
specifying how many groups do you want to split the data available; or else a factor
specifying these groups}

\item{doAll}{boolean; should each group be used once for validating the model constructed
with the remaining groups; else, only the first group will be used for validation, and the other
will be used for training.}

\item{...}{ignored}
}
\value{
An object, a list with an appropriate class, controlling the strategy specified.
This can be of class "NfoldCrossValidation" or of class  c("LeaveOneOut", "NfoldCrossValidation").
}
\description{
Specify a strategy to validate a spatial model. Currently only
leave-one-out and n-fold cross-validation are available, each specified
by its own function. Leave-one-out takes no parameter.
}
\examples{
NfoldCrossValidation(nfolds=5, doAll=FALSE)
}
\seealso{
Other validation functions: 
\code{\link{LeaveOneOut}},
\code{\link{validate}()}
}
\concept{validation functions}
