% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meter.R
\name{Meter}
\alias{Meter}
\title{Create \code{Meter} Object}
\usage{
Meter(
  number,
  unit,
  bar = NULL,
  actual_number = NULL,
  actual_unit = NULL,
  invisible = NULL
)
}
\arguments{
\item{number}{A positive number to represent the upper numeral in a
time signature symbol, which indicates how many beats are contained in
each measure.}

\item{unit}{1, 2, 4, 8, 16, 32 or 64 to represent the lower numeral in
a time signature symbol, which indicates the duration of one beat.}

\item{bar}{Optional. A positive integer which indicates the number of
the measure into which to insert the \code{Meter} object. By default, a \code{Meter}
object will be inserted into the first measure(s).}

\item{actual_number, actual_unit}{Optional, which defines the actual
time signature rather than the time signature symbol on score. Usually
used to create pickup measures. By default, these two arguments are the
same with \code{number} and \code{unit} respectively.}

\item{invisible}{Optional. A single logical, which indicates whether to
show the time signature symbol on score. The default value is \code{FALSE}.}
}
\value{
A list with class \code{Meter}.
}
\description{
Create a \code{Meter} object.

\code{Meter} objects represent time signatures.
}
\examples{
# create a 3/4 time signature
Meter(3, 4)

# insert a time signature into a specific measure
Music() + Meter(3, 4, bar = 10)

m <- Music() + Line(list("C5"), list(3))

# specify the actual time signature
ts <- Meter(3, 4, actual_number = 1, actual_unit = 4)
ts

if (interactive()) {
  show(m + ts)
}

# make a time signature invisible on score
if (interactive()) {
  ts <- Meter(3, 4, invisible = TRUE)
  show(m + ts)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding \code{Meter} objects to a \code{Music} object.
}
