% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clef.R
\name{Clef}
\alias{Clef}
\title{Create \code{Clef} Object}
\usage{
Clef(sign, line = NULL, octave = NULL, to = NULL, bar = NULL, offset = NULL)
}
\arguments{
\item{sign}{"G", "F" or "C", case insensitive.}

\item{line}{Optional, 1 or 2 if \code{sign} is "G", an integer between 3 and 5
if \code{sign} is "F", or an integer between 1 and 5 if \code{sign} is "C".}

\item{octave}{Optional, -1 or 1. \code{octave} can be specified only when
\code{sign} is "G" and \code{line} is 2, or \code{sign} is "F" and \code{line} is 4.}

\item{to}{an index or a \code{Line} name, which indicates to which \code{Line} object
to add the \code{Clef} object.}

\item{bar}{Optional. A positive integer which indicates the number of
the measure to which to add the \code{Clef} object. By default, a \code{Clef}
object will be added to the first measure.}

\item{offset}{Optional. A duration value, sum of duration values or 0,
which indicates the position in a measure, at which to add the \code{Clef}
object. The default value is 0.}
}
\value{
A list with class \code{Clef}.
}
\description{
Create a \code{Clef} object.

\code{Clef} objects represent clefs.
}
\examples{
# create a Clef object
Clef("G", line = 2, octave = 1)

# add a Clef object to a Music object
Music() +
  Line(list("C4"), list(1)) +
  Clef("F", to = 1, bar = 10, offset = 1)
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding \code{Clef} objects to a \code{Music} object.

\code{vignette("gm", package = "gm")} for details about duration values.
}
