% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto-parse.R
\name{auto_parse}
\alias{auto_parse}
\title{Automatic Structure Parsing}
\usage{
auto_parse(x)
}
\arguments{
\item{x}{A character vector of structure strings.}
}
\value{
A \code{\link[glyrepr:glycan_structure]{glyrepr::glycan_structure()}} object.
}
\description{
Detect the structure string type and use the appropriate parser
to parse automatically.
Mixed types are supported.

Supported types:
\enumerate{
\item GlycoCT
\item IUPAC-condensed
\item IUPAC-extended
\item IUPAC-short
\item WURCS
\item Linear Code
\item pGlyco
\item StrucGP
}
}
\examples{
# Single structure
x <- "Gal(b1-3)GlcNAc(b1-4)Glc(a1-"  # IUPAC-condensed
auto_parse(x)

# Mixed types
x <- c(
  "Gal(b1-3)GlcNAc(b1-4)Glc(a1-",  # IUPAC-condensed
  "Neu5Aca3Gala3(Fuca6)GlcNAcb-"  # IUPAC-short
)
auto_parse(x)

}
