% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar.r
\name{plot_bar}
\alias{plot_bar}
\alias{plot_bar.exp_score}
\alias{plot_bar.abnorm_score}
\title{Create barplot for cross-sectional globaltrends data}
\usage{
plot_bar(data, ...)

\method{plot_bar}{exp_score}(data, type = c("obs", "sad", "trd"), ...)

\method{plot_bar}{abnorm_score}(data, ...)
}
\arguments{
\item{data}{Data exported from \code{export_...} or \code{compute_abnorm} functions.}

\item{...}{Further arguments passed to or from other methods.}

\item{type}{Object of type \code{character} indicating the type of time
series-column from data_score, takes either \emph{obs}, \emph{sad}, or \emph{trd}. Defaults
to \emph{"obs"}.}
}
\value{
Barplot of cross-sectional data as \code{ggplot2} object.
}
\description{
The function creates barplots for cross-sectional search score data. It uses
the output of \code{export_score} to prepare a bar plot of search scores for
the top 10 countries. For output from \code{get_abnorm_hist} the plot shows
five locations with the highest and lowest abnormal changes each. When the
output includes more than one keyword, only the first keyword is used.
}
\examples{
\dontrun{
data <- export_score(keyword = "amazon")
plot_bar(data, type = "obs")

data <- export_score(keyword = "amazon")
data <- get_abnorm_hist(data, train_win = 12, train_break = 0, type = "obs")
plot_bar(data)
}

}
