% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{advertising}
\alias{advertising}
\title{Advertising}
\format{
A data frame with 200 rows and 4 variables:
\describe{
  \item{TV}{a numeric vector indicating the advertising budget on TV.}
  \item{radio}{a numeric vector indicating the advertising budget on radio.}
  \item{newspaper}{a numeric vector indicating the advertising budget on newspaper.}
  \item{sales}{a numeric vector indicating the sales of the interest product.}
}
}
\source{
\url{https://www.statlearning.com/s/Advertising.csv}
}
\usage{
data(advertising)
}
\description{
The advertising data set consists of sales of that product
in 200 different markets. It also includes advertising budgets for the
product in each of those markets for three different media: TV, radio,
and newspapers.
}
\examples{
data(advertising)
breaks <- with(advertising,quantile(radio,probs=c(0:3)/3))
labels <- c("low","mid","high")
advertising2 <- within(advertising,radioC <- cut(radio,breaks,labels,include.lowest=TRUE))
dev.new()
with(advertising2,plot(TV,sales,pch=16,col=as.numeric(radioC)))
legend("topleft",legend=c("low","mid","high"),fill=c(1:3),title="Radio",bty="n")
}
\references{
James G., Witten D., Hastie T., Tibshirani R. (2013, page 15) \emph{An Introduction to Statistical Learning with Applications in R}, Springer, New York.
}
\keyword{datasets}
