% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{gnmgee}
\alias{gnmgee}
\title{Fit Nonlinear Generalized Estimating Equations}
\usage{
gnmgee(
  formula,
  family = gaussian(),
  offset = NULL,
  weights = NULL,
  id,
  waves,
  data,
  subset = NULL,
  corstr,
  corr,
  start = NULL,
  scale.fix = FALSE,
  scale.value = 1,
  toler = 1e-05,
  maxit = 50,
  trace = FALSE,
  ...
)
}
\arguments{
\item{formula}{a nonlinear model \code{formula} including variables and parameters, which is a symbolic description of the nonlinear predictor of the model to be fitted to the data.}

\item{family}{an (optional) \code{family} object, that is, a list of functions and expressions for defining link and variance functions. Families (and links) supported are the same supported by \link{glm} using its \link{family} argument, that is,
\code{gaussian}, \code{binomial}, \code{poisson}, \code{Gamma}, \code{inverse.gaussian}, and \code{quasi}. The family \code{negative.binomial} in the library \pkg{MASS} are also available. As default, the argument \code{family} is set to \code{gaussian(identity)}.}

\item{offset}{an (optional) numeric vector of length equal to the number of cases, which can be used to specify an a priori known component to be included in the linear predictor during fitting.}

\item{weights}{an (optional) vector of positive "prior weights" to be used in the fitting process. The length of \code{weights} should be the same as the total number of observations.}

\item{id}{a vector which identifies the subjects or clusters. The length of \code{id} should be the same as the number of observations.}

\item{waves}{an (optional) positive integer-valued variable that is used to identify the order and spacing of observations within clusters. This argument is crucial when there are missing values and gaps in the data. As default, \code{waves} is equal to the integers from 1 to the size of each cluster.}

\item{data}{an (optional) \code{data frame} in which to look for variables involved in the \code{formula} expression, as well as for variables specified in the arguments \code{id} and \code{weights}. The data are assumed to be sorted by \code{id} and time.}

\item{subset}{an (optional) vector specifying a subset of observations to be used in the fitting process.}

\item{corstr}{an (optional) character string which allows to specify the working-correlation structure. The available options are: "Independence", "Unstructured", "Stationary-M-dependent(\emph{m})", "Non-Stationary-M-dependent(\emph{m})", "AR-M-dependent(\emph{m})", "Exchangeable" and "User-defined", where \emph{m} represents the lag of the dependence. As default, \code{corstr} is set to "Independence".}

\item{corr}{an (optional) square matrix of the same dimension of the maximum cluster size containing the user specified correlation. This is only appropriate if \code{corstr} is specified to be "User-defined".}

\item{start}{an (optional) vector of starting values for the parameters in the nonlinear predictor. When \code{start} is
missing (and \code{formula} is not a self-starting model, see \link{nls} and \link{selfStart}), a very cheap guess for \code{start} is tried.}

\item{scale.fix}{an (optional) logical variable. If TRUE, the scale parameter is fixed at the value of \code{scale.value}. As default, \code{scale.fix} is set to FALSE.}

\item{scale.value}{an (optional) numeric value at which the scale parameter should be fixed. This is only appropriate if \code{scale.fix=TRUE}. As default, \code{scale.value} is set to 1.}

\item{toler}{an (optional) positive value which represents the \emph{convergence tolerance}. The convergence is reached when the maximum of the absolute relative differences between the values of the parameters in the nonlinear predictor in consecutive iterations of the fitting algorithm is lower than \code{toler}. As default, \code{toler} is set to 0.00001.}

\item{maxit}{an (optional) integer value which represents the maximum number of iterations allowed for the fitting algorithm. As default, \code{maxit} is set to 50.}

\item{trace}{an (optional) logical variable. If TRUE, output is produced for each iteration of the estimating algorithm.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
an object of class \emph{glmgee} in which the main results of the GEE model fitted to the data are stored, i.e., a
list with components including
\tabular{ll}{
\code{coefficients} \tab a vector with the estimates of \eqn{\beta_1,\ldots,\beta_p},\cr
\tab \cr
\code{fitted.values}\tab a vector with the estimates of \eqn{\mu_{ij}} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{start}        \tab a vector with the starting values used,\cr
\tab \cr
\code{iter}         \tab a numeric constant with the number of iterations,\cr
\tab \cr
\code{prior.weights}\tab a vector with the values of \eqn{\omega_{ij}} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{offset}       \tab a vector with the values of \eqn{z_{ij}} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{terms}        \tab an object containing the terms objects,\cr
\tab \cr
\code{loglik}       \tab the value of the quasi-log-likelihood function evaluated at the parameter\cr
                    \tab estimates and the observed data,\cr
\tab \cr
\code{estfun}       \tab a vector with the estimating equations evaluated at the parameter\cr
                    \tab estimates and the observed data,\cr
\tab \cr
\code{formula}      \tab the formula,\cr
\tab \cr
\code{levels}       \tab the levels of the categorical regressors,\cr
\tab \cr
\code{contrasts}    \tab an object containing the contrasts corresponding to levels,\cr
\tab \cr
\code{converged}    \tab a logical indicating successful convergence,\cr
\tab \cr
\code{model}        \tab the full model frame,\cr
\tab \cr
\code{y}            \tab a vector with the values of \eqn{y_{ij}} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{family}       \tab an object containing the \link{family} object used,\cr
\tab \cr
\code{linear.predictors} \tab a vector with the estimates of \eqn{g(\mu_{ij})} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{R}            \tab a matrix with the (robust) estimate of the variance-covariance,\cr
\tab \cr
\code{corr}         \tab a matrix with the estimate of the working-correlation,\cr
\tab \cr
\code{corstr}       \tab a character string specifying the working-correlation structure,\cr
\tab \cr
\code{id}           \tab a vector which identifies the subjects or clusters,\cr
\tab \cr
\code{sizes}        \tab a vector with the values of \eqn{n_i} for \eqn{i=1,\ldots,n},\cr
\tab \cr
\code{call}         \tab the original function call,\cr
}
}
\description{
Produces an object of the class \code{glmgee} in which the main results of a Nonlinear Generalized Estimating Equation (GEE) fitted to the data are stored.
}
\details{
The values of the multivariate response variable measured on \eqn{n} subjects or clusters,
denoted by \eqn{y_{i}=(y_{i1},\ldots,y_{in_i})^{\top}} for \eqn{i=1,\ldots,n}, are assumed to be
realizations of independent random vectors denoted by \eqn{Y_{i}=(Y_{i1},\ldots,Y_{in_i})^{\top}}
for \eqn{i=1,\ldots,n}. The random variables associated to the \eqn{i}-th subject or
cluster, \eqn{Y_{ij}} for \eqn{j=1,\ldots,n_i}, are assumed to satisfy
\eqn{\mu_{ij}=} E\eqn{(Y_{ij})},Var\eqn{(Y_{ij})=\frac{\phi}{\omega_{ij}}}V\eqn{(\mu_{ij})}
and Corr\eqn{(Y_{ij},Y_{ik})=r_{jk}(\rho)},
where \eqn{\phi>0} is the dispersion parameter,
V\eqn{(\mu_{ij})} is the variance function, \eqn{\omega_{ij}>0} is a known weight, and
\eqn{\rho=(\rho_1,\ldots,\rho_q)^{\top}} is a parameter vector.
In addition, \eqn{\mu_{ij}} is assumed to be dependent on the regressors vector \eqn{x_{ij}}
by \eqn{g(\mu_{ij})=z_{ij} + m(x_{ij},\beta)}, where \eqn{g(\cdot)} is the link function,
\eqn{z_{ij}} is a known \emph{offset}, \eqn{\beta=(\beta_1,\ldots,\beta_p)^{\top}} is
a vector of regression parameters and \eqn{m(x_{ij},\beta)} is a known nonlinear function of \eqn{\beta}.
The parameter estimates are obtained by iteratively
solving the estimating equations described by Liang and Zeger (1986).

If the maximum cluster size is 6 and for a cluster of size 4 the value
of \code{waves} is set to 2, 4, 5, 6, then it means that the data at
times 1 and 3 are missing, which should be taken into account by
\code{gnmgee} when the structure of the correlation matrix is assumed
to be "Unstructured", "Stationary-M-dependent", "Non-Stationary-M-dependent"
or "AR-M-dependent". If in this scenario \code{waves} is not specified
then \code{gnmgee} assumes that the available data for this cluster
were taken at times 1, 2, 3 and 4.

A set of standard extractor functions for fitted model objects is
available for objects of class \emph{glmgee}, including methods to generic functions such as   \code{print}, \code{summary},	\code{model.matrix}, \code{estequa},
\code{coef}, \code{vcov}, \code{logLik}, \code{fitted}, \code{confint} and \code{predict}.
In addition, the model may be assessed using functions such as \link{anova.glmgee},
\link{residuals.glmgee}, \link{dfbeta.glmgee} and \link{cooks.distance.glmgee}.
}
\examples{
###### Example : Orange trees grown at Riverside, California
data(Oranges)
mod <- Trunk ~ b1/(1 + exp((b2-Days)/b3))
start <- c(b1=200,b2=760,b3=375)
fit1 <- gnmgee(mod, start=start, id=Tree, family=Gamma(identity), corstr="Exchangeable",
               data=Oranges)
summary(fit1, corr.digits=2)

mod <- Trunk ~ SSlogis(Days,b1,b2,b3)
fit2 <- gnmgee(mod, id=Tree, family=Gamma(identity), corstr="Exchangeable", data=Oranges)
summary(fit2, corr.digits=2)

}
\references{
Liang K.Y., Zeger S.L. (1986) Longitudinal data analysis using generalized linear models.
\emph{Biometrika} 73:13-22.

Zeger S.L., Liang K.Y. (1986) Longitudinal data analysis for discrete and continuous outcomes.
\emph{Biometrics} 42:121-130.

Hardin J.W., Hilbe J.M. (2013) \emph{Generalized Estimating Equations}. Chapman & Hall, London.

\href{https://journal.r-project.org/articles/RJ-2023-056/}{Vanegas L.H., Rondon L.M., Paula G.A. (2023) Generalized Estimating Equations using the new R package glmtoolbox.
\emph{The R Journal} 15:105-133.}
}
\seealso{
\link{glmgee}, \link{wglmgee}
}
