% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{cooks.distance.glmgee}
\alias{cooks.distance.glmgee}
\title{Cook's Distance for Generalized Estimating Equations}
\usage{
\method{cooks.distance}{glmgee}(model, plot.it = TRUE, coefs, identify, ...)
}
\arguments{
\item{model}{an object of class glmgee obtained from the fit of a generalized estimating equation.}

\item{plot.it}{an (optional) logical indicating if the plot of Cook's distance is required or just the data matrix in which that plot is based. By default, \code{plot.it} is set to be TRUE.}

\item{coefs}{an (optional) character string which (partially) match with the names of some of the parameters in the linear predictor.}

\item{identify}{an (optional) integer indicating the number of clusters to identify on the plot of Cook's distance. This is only appropriate if \code{plot.it=TRUE}.}

\item{...}{further arguments passed to or from other methods. If \code{plot.it=TRUE} then \code{...} may be used to include graphical parameters to customize the plot. For example,  \code{col}, \code{pch}, \code{cex}, \code{main}, \code{sub}, \code{xlab}, \code{ylab}.}
}
\value{
A matrix as many rows as clusters in the sample and one column with the values of the Cook's distance.
}
\description{
Produces an approximation, better known as the \emph{one-step aproximation}, of the Cook's distance, which is aimed to measure the effect on the estimates of the parameters in the linear predictor of deleting each cluster in turn. This function also can produce a cluster-index plot of the Cook's distance for all parameters in the linear predictor or for some subset of them.
}
\details{
The Cook's distance consists of the \emph{distance} between two estimates of the parameters in the linear predictor using a metric based on the (estimate of the) variance-covariance matrix. The first one set of estimates is computed from a dataset including all clusters, and the second one is computed from a dataset in which the \emph{i}-th cluster is excluded. To avoid computational burden, the second set of estimates is replaced by its \emph{one-step approximation}. See the \link{dfbeta.glmgee} documentation.
}
\examples{
## Cook's distance for all parameters in the linear predictor
mod <- size ~ poly(days,4) + treat
fit <- glmgee(mod, id=tree, family=Gamma("log"), data=spruce, corstr="Exchangeable")
cooks.distance(fit, col="red", lty=1, lwd=1, col.lab="blue", main="Cook's distance",
               col.axis="blue", col.main="black", family="mono", cex=0.8)

## Cook's distance for the parameter associated to the variable treat
cooks.distance(fit, coef="treat", col="red", lty=1, lwd=1, col.lab="blue",
               main="Cook's distance", col.axis="blue", col.main="black",
               family="mono", cex=0.8)
}
