# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generates the covariance matrix of the random effects
#' 
#' Generates the covariance matrix of the random effects from a sparse representation. Used internally in the Covariance class.
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param gamma Vector of parameters used to generate the matrix D. 
#' @return A symmetric positive definite covariance matrix
genD <- function(cov, data, eff_range, gamma) {
    .Call(`_glmmrBase_genD`, cov, data, eff_range, gamma)
}

#' Generates the Cholesky decomposition covariance matrix of the random effects
#' 
#' Generates the Cholesky Decomposition of the covariance matrix of the random effects. Used internally in the Covariance class.
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of varaibles
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param gamma Vector of parameters used to generate the matrix D. 
#' @return A lower triangular matrix
genCholD <- function(cov, data, eff_range, gamma) {
    .Call(`_glmmrBase_genCholD`, cov, data, eff_range, gamma)
}

#' Generates a sample of random effects
#' 
#' Generates a sample of random effects from the specified covariance matrix.
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of varaibles
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param gamma Vector of parameters used to generate the matrix D. 
#' @return A lower triangular matrix
sample_re <- function(cov, data, eff_range, gamma) {
    .Call(`_glmmrBase_sample_re`, cov, data, eff_range, gamma)
}

#' Generates the derivative of the link function with respect to the mean. Used internally in the Model function class.
#' 
#' @param xb Vector with mean function value evaluated at fitted model parameters
#' @param family String declaring model family
#' @param link String declaring model link function
#' @return Vector of derivative values
gen_dhdmu <- function(xb, family, link) {
    .Call(`_glmmrBase_gen_dhdmu`, xb, family, link)
}

