% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maPlot.R
\name{maPlot}
\alias{maPlot}
\title{MA plots}
\usage{
maPlot(
  object,
  x1var,
  x2var,
  x1Values = NULL,
  x2Values = NULL,
  pCutoff = 0.01,
  plotCutoff = 1,
  zeroCountCutoff = 50,
  colours = c("grey", "midnightblue", "mediumvioletred", "goldenrod"),
  labels = c(),
  fontSize = 12,
  labelFontSize = 4,
  useAdjusted = FALSE,
  graphics = "ggplot",
  verbose = FALSE
)
}
\arguments{
\item{object}{A glmmSeq object created by
\code{\link[glmmSeq:glmmSeq]{glmmSeq::glmmSeq()}}.}

\item{x1var}{The name of the first (inner) x parameter}

\item{x2var}{The name of the second (outer) x parameter}

\item{x1Values}{Timepoints or categories in \code{x1var} to be used to calculate fold
change. If \code{NULL} the first two levels in \code{x1var} are used.}

\item{x2Values}{Categories in \code{x2var} to be compared on x and y axis.}

\item{pCutoff}{The significance cut-off for colour-coding (default=0.01)}

\item{plotCutoff}{Which probes to include by significance cut-off
(default=1 for all markers)}

\item{zeroCountCutoff}{Which probes to include by minimum counts cut-off
(default=50)}

\item{colours}{Vector of colours to use for significance groups}

\item{labels}{Row names or indices to label on plot}

\item{fontSize}{Font size}

\item{labelFontSize}{Font size for labels}

\item{useAdjusted}{whether to use adjusted p-values
(must have q-values in \code{object})}

\item{graphics}{Either "ggplot" or "plotly"}

\item{verbose}{Whether to print statistics}
}
\value{
List of three plots. One plot for each \code{x2Value} and one combined
figure
}
\description{
MA plots
}
\examples{
data(PEAC_minimal_load)

disp <- apply(tpm, 1, function(x){
(var(x, na.rm=TRUE)-mean(x, na.rm=TRUE))/(mean(x, na.rm=TRUE)**2)
})

resultTable <- glmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                       countdata = tpm[1:5, ],
                       metadata = metadata,
                       dispersion = disp)

plots <- maPlot(resultTable,
                x1var='Timepoint',
                x2var='EULAR_6m',
                x2Values=c('Good', 'Non-response'),
                graphics="plotly")

plots$combined
}
\keyword{hplot}
