% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmRefit.R
\name{glmmRefit}
\alias{glmmRefit}
\title{Refit mixed effects model}
\usage{
glmmRefit(object, gene, ...)
}
\arguments{
\item{object}{A fitted results object of class \code{GlmmSeq} or \code{lmmSeq}}

\item{gene}{A character value specifying a single gene to extract a fitted
model for}

\item{...}{Optional arguments passed to either \link[lme4:glmer]{lme4::glmer} or \link[lme4:lmer]{lme4::lmer}}
}
\value{
Fitted model of class \code{lmerMod} in the case of LMM or \code{glmerMod} for
a GLMM
}
\description{
Based on a 'GlmmSeq' or 'lmmSeq' class result object, this function attempts
to refit an identical model for a specific gene based on the data and fitting
parameters stored in the results object and refitting using either
\code{\link[lme4:glmer]{lme4::glmer()}} for \code{GlmmSeq} objects or \code{lmer()} for \code{lmmSeq} objects. The
fitted model can then be passed on to other packages such as \code{emmeans} to
look at estimated marginal means for the model.
}
