% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_options.R
\name{lambdaControl}
\alias{lambdaControl}
\alias{selectControl}
\title{Control of Penalization Parameters and Selection Criteria}
\usage{
lambdaControl(lambda0 = 0, lambda1 = 0)

selectControl(
  lambda0_seq = NULL,
  lambda1_seq = NULL,
  nlambda = 10,
  search = c("abbrev", "full_grid"),
  BIC_option = c("BICq", "BICh", "BIC", "BICNgrp"),
  logLik_calc = switch(BIC_option[1], BICq = FALSE, TRUE),
  lambda.min = NULL,
  pre_screen = TRUE,
  lambda.min.presc = NULL
)
}
\arguments{
\item{lambda0}{a non-negative numeric penalty parameter for the fixed effects parameters}

\item{lambda1}{a non-negative numeric penalty parameter for the (grouped) random effects
covariance parameters}

\item{lambda0_seq, lambda1_seq}{a sequence of non-negative numeric penalty parameters for the fixed 
and random effect parameters, respectively. If \code{NULL}, then a sequence will be automatically 
calculated. See 'Details' section for more details on these default calculations.}

\item{nlambda}{positive integer specifying number of penalty parameters (lambda) 
to use for the fixed and random effects penalty parameters. Default set to 10.
Ignored if \code{lambda0_seq} and \code{lambda1_seq} are specified by the user.}

\item{search}{character string of "abbrev" (default) or "full_grid" indicating if the search of models over 
the penalty parameter space should be the full grid search (total number of models equals
`nlambda`^2 or length(`lambda0_seq`)*length(`lambda1_seq`)) or an abbreviated grid search.
The abbreviated grid search is described in more detail in the Details section. Te authors
highly recommend the abbreviated grid search.}

\item{BIC_option}{character string specifying the selection criteria used to select the 'best' model.
Default "BICq" option specifies the BIC-ICQ criterion (Ibrahim et al (2011)
<doi:10.1111/j.1541-0420.2010.01463.x>),
which requires a fit of 
a full model; a small penalty (the minimum of the penalty sequence) 
is used for the fixed and random effects. 
The "BICh" option utilizes the hybrid BIC value described in 
Delattre, Lavielle, and Poursat (2014) <doi:10.1214/14-EJS890>.
The regular "BIC" option penalty term uses (total non-zero coefficients)*(length(y) = total number
observations). The "BICNgrp" option penalty term uses (total non-zero coefficients)*(nlevels(group) = number
groups).}

\item{logLik_calc}{logical value specifying if the log likelihood (and log-likelihood based 
calculations BIC, BICh, and BICNgrp) should be calculated for all of the models in the selection procedure. 
If BIC-ICQ is used for selection, the log-likelihood is not needed for each model. 
However, if users are interested
in comparing the best models from BIC-ICQ and other BIC-type selection criteria, setting
\code{logLik_calc} to \code{TRUE} will calculate these other quantities for all of the models.}

\item{lambda.min}{numeric fraction between 0 and 1. The sequence of the lambda penalty parameters
ranges from the maximum lambda where all fixed and random effects are penalized to 0 and 
a minimum lambda value, which equals a small fraction of the maximum lambda. The parameter 
\code{lambda.min} specifies this fraction. Default value is set to \code{NULL}, which
automatically selects \code{lambda.min} to equal 0.01 when p <= 10 and 0.05 when p > 10.}

\item{pre_screen}{logical value indicating whether pre-screening should be performed before
model selection (default \code{TRUE}). If the number of random effects considered less than 5,
no pre-screening will be performed. Pre-screening removes random effects from consideration
during the model selection process, which can significantly speed up the algorithm.}

\item{lambda.min.presc}{numeric fraction between 0 and 1. During pre-screening and the full
model fit for the BIC-ICQ calculation, the small penalty used on the random effect is
the fraction \code{lambda.min.presc} mulitplied by the maximum penalty parameter that penalizes
all fixed and random effects to 0. If left as \code{NULL}, the default value is 0.01 when the number
of random effects is 10 or less and 0.05 otherwise.}
}
\value{
The *Control functions return a list (inheriting from class "\code{pglmmControl}") 
containing parameter values that determine settings for variable selection.
}
\description{
Constructs control structures for penalized mixed model fitting.
}
\details{
If unspecified, the \code{lambda0_seq} and \code{lambda1_seq} numeric sequences are 
automatically calculated. The sequence will be calculated in the same manner as 
\code{ncvreg} calculates the range: max penalizes all fixed and random effects to 0, min is a 
small portion of max (\code{lambda.min}*(lambda max)), sequence is composed of 
\code{nlambda} values spread evenly on the log scale. Unlike \code{ncvreg}, the order of penalty
values used in the algorithm must run from the min lambda to the max lambda (as opposed to 
running from max lambda to min lambda). The length of the sequence is specified by \code{nlambda}. 
By default, these sequences are calculated using \code{\link{LambdaSeq}}.

The \code{lambda0} and \code{lambda1} arguments allow for a user to fit a model with a single 
non-zero penalty parameter combination. However, this is generally not recommended. 

Abbreviated grid search: The abbreviated grid search proceeds in two stages. In stage 1, the
algorithm fits the following series of models: the fixed effects penalty parameter remains a
fixed value evaluated at the minimum of the fixed effects penalty parameters, and a all
random effects penalty parameters are examined. The 'best' model from this first stage of models
determines the optimum random effect penalty parameter. In stage 2, the algorithm fits the 
following series of models: the random effects penalty parameter remains fixed at the value of
the optimum random effect penalty parameter (from stage 1) and all fixed effects penalty
parameters are considered. The best overall model is the best model from stage 2. This reduces the 
number of models considered to length(`lambda0_seq`) + length(`lambda1_seq`). The authors found
that this abbreviated grid search worked well in simulations.
}
