% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glinvci.R
\name{fit}
\alias{fit}
\alias{fit.glinv}
\title{Fitting a GLInv model via numerical optimisation}
\usage{
fit(mod, ...)

\method{fit}{glinv}(
  mod,
  parinit = NULL,
  method = "L-BFGS-B",
  lower = -Inf,
  upper = Inf,
  use_optim = FALSE,
  project = NULL,
  projectArgs = NULL,
  control = list(),
  ...
)
}
\arguments{
\item{mod}{An object of class \code{\link{glinv}}.}

\item{...}{Not used.}

\item{parinit}{A vector, parameter for initialisation of the optimisation routine.}

\item{method}{One of \code{L-BFGS-B}, \code{CG}, \code{BB}, or any other methods which is accepted by optim.}

\item{lower}{A vector of lower bounds on the parameters.}

\item{upper}{A vector of upper bounds on the parameters.}

\item{use_optim}{If true, use optim's version of \code{L-BFGS-B} and \code{CG}.}

\item{project}{Passed to \code{BBoptim}.}

\item{projectArgs}{Passed to \code{BBoptim}.}

\item{control}{Options to be passed into each the underlying optimisation routine's \code{control}
argument.}
}
\value{
\code{fit.glinv} returns a list containing at least the following elements:
                    \item{mlepar}{The maximum likelihood estimate.}
                    \item{loglik}{The log-likelihood at the maximum likelihood estimate.}
                    \item{score}{The gradient of log-likelihood at the maximum likelihood estimate.}
                    \item{convergence}{Zero if the optimisation routine has converged successfully.}
                    \item{message}{A message from the optimisation routine.}
}
\description{
\code{fit.glinv} finds the maximum likelihood estimate of a \code{glinv} model by solving a numerical
optimisation problem.
}
\details{
If \code{method} is \code{L-BFGS-B}, then \code{\link[lbfgsb3c]{lbfgsb3c}} is used for optimisation;
if it is \code{CG} then \code{\link[Rcgmin]{Rcgmin}} is used; if it is \code{BB} then
\code{\link[BB]{BBoptim}} is used, otherwise the method argument is passed to \code{\link{optim}}.

By default, \code{L-BFGS-B} declares convergence when the change of function value is small, \code{CG}
tests stops when change of gradient squared-Euclidean-norm is small, \code{BB} stops when either the
change of function values, or the infinity norm of a project gradient, is small. These can be changed
through the \code{control} argument and the user should refer to the optimisation packages' respective
documentation for details.

The user can opt for using \code{\link{optim}}'s version of \code{CG} and \code{L-BFGS-B}. The
implementation in \code{\link{optim}} of the methods does not incorporate improvements of the
methods in the recent decades, but they have stood the test of time.

If \code{parinit} were not supplied and the distance between \code{lower} and \code{upper} is infinite,
the initialisation point of the optimisation is drawn from a uniform distribution ranging [-1,1]
distribution. If initalisation were not supplied, but the distance between \code{lower} and \code{upper}
is finite, then the initialisation is drawn from a uniform distribution ranging
[\code{lower}, \code{upper}].
}
