% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_numerical_vars.R
\name{plot_numerical_vars}
\alias{plot_numerical_vars}
\title{Plot Continuous Variables}
\usage{
plot_numerical_vars(x, plot_type)
}
\arguments{
\item{x}{Data frame which may include continuous and discrete
variables. Non-continuous variables are ignored.}

\item{plot_type}{Plot type. Current options: \describe{

\item{\code{"pairwise"}}{Calls \code{\link[GGally]{ggpairs}} to
get plots of pairwise differences. Avoid it if there are too many
numerical variables.}

\item{\code{"density"}}{Calls \code{\link[ggplot2]{geom_density}}
and \code{\link[ggplot2]{geom_rug}}.}

\item{\code{"histogram"}}{Calls
\code{\link[ggplot2]{geom_histogram}} and
\code{\link[ggplot2]{geom_rug}}.}

\item{\code{"violin"}}{Calls \code{\link[ggplot2]{geom_violin}}
and \code{\link[ggplot2]{geom_jitter}}.}

\item{\code{"boxplot"}}{Calls
\code{\link[ggplot2]{geom_boxplot}}.}

\item{\code{"qqplot"}}{Calls
\code{\link[ggplot2]{stat_qq_line}} and
\code{\link[ggplot2]{stat_qq}}.}
}}
}
\value{
A ggplot object.
}
\description{
Graphical summaries of numerical variables using functions from
\code{ggplot2} and \code{GGally}.
}
\examples{
library(glancedata)

plot_numerical_vars(iris, "pairwise")
plot_numerical_vars(iris, "density")
plot_numerical_vars(iris, "boxplot")
plot_numerical_vars(iris, "violin")
plot_numerical_vars(iris, "histogram")
plot_numerical_vars(iris, "qqplot")
}
\author{
Guillermo Basulto-Elias
}
