% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glance_data_in_workbook.R
\name{glance_data_in_workbook}
\alias{glance_data_in_workbook}
\title{Export glance data to Excel Workbook}
\usage{
glance_data_in_workbook(dataframe, filename = NULL, limit2tally = 20)
}
\arguments{
\item{dataframe}{Dataframe to be summarized}

\item{filename}{File name of the Excel file, e.g.,
"mydataglance.xlsx". By default, no file name is provided and,
therefore, no Excel is created.}

\item{limit2tally}{One of the summaries is a tally of the distinct
values on each column. If there are too many different values
in a column, this summary would be meaningless. This
\code{limit2tally} is the limit of distinct values to
tally. If there are more than that it returns
"Too many unique values".}
}
\value{
A list
}
\description{
It is similar to \code{\link{glance_data}} but instead of creating
a single dataframe, it creates a list of seven dataframes:
\describe{
\item{\code{all}}{Same output as \code{\link{glance_data}}.}
\item{\code{summary}}{A tally of columns by type. A dataframe with
two columns: column type and count.}
\item{\code{all_nas}}{Summary of columns with only NAs.}
\item{\code{single_value}}{Summary of columns with a single value
besides NAs. It might be numeric or character.}
\item{\code{binary}}{Summary of columns with two values besides
NAs. It might be numerical or categorical.}
\item{\code{numerical}}{Summary of all numerical columns when
there are more than two possible values.}
\item{\code{categorical}}{Summary of all categorical columns when
there are more than two possible values.}
}
}
\details{
If a XLSX file name is provided, it will create a file with seven
sheets, corresponding to the seven dataframes above.

Finally, the last elements of the list (and the last five sheets
if the filename is provided), are disjoint. That is, if a the
summary of a column is included in "binary", it will not be
included in "numerical".
}
\examples{
## Create a list of dataframes. If you provide the `filename`
## parameter to be equal to, say, "myglance.xlsx", then it will
## create an Excel workbook and place the content of each
## dataframe in a separate sheet.
glance_data_in_workbook(iris)
}
\author{
Guillermo Basulto-Elias
}
