% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculateParameters}
\alias{calculateParameters}
\title{Calculate Parameters for the Generalized Kumaraswamy Distribution}
\usage{
calculateParameters(
  X1,
  X2,
  X3,
  X4,
  X5,
  beta1,
  beta2,
  beta3,
  beta4,
  beta5,
  link_types,
  scale_factors,
  family = "gkw"
)
}
\arguments{
\item{X1}{NumericMatrix design matrix for alpha.}

\item{X2}{NumericMatrix design matrix for beta.}

\item{X3}{NumericMatrix design matrix for gamma.}

\item{X4}{NumericMatrix design matrix for delta.}

\item{X5}{NumericMatrix design matrix for lambda.}

\item{beta1}{NumericVector regression coefficients for X1.}

\item{beta2}{NumericVector regression coefficients for X2.}

\item{beta3}{NumericVector regression coefficients for X3.}

\item{beta4}{NumericVector regression coefficients for X4.}

\item{beta5}{NumericVector regression coefficients for X5.}

\item{link_types}{IntegerVector containing the link function type for each parameter.}

\item{scale_factors}{NumericVector with scale factors for each parameter.}

\item{family}{String specifying the distribution family (default: "gkw").}
}
\value{
NumericMatrix with n rows and 5 columns corresponding to the calculated parameters.
}
\description{
Computes the parameters (alpha, beta, gamma, delta, lambda) for each observation based on design matrices and regression coefficients,
applying a positive link function as specified by link types and scale factors.
}
